/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.autoupdate;

import java.io.File;
import java.io.IOException;
import java.util.*;

import org.openide.util.NbBundle;
import org.openide.util.datatransfer.NewType;

/** Represents add Nbm object in the Option - Modules - New.
 * XXX use Looks in the future
 * @author Ales Kemr
 */
public class AutoModuleNewType extends NewType {
        
    public String getName () {
        return NbBundle.getMessage( AutoModuleNewType.class, "CTL_NewModuleByNBM" );
    }

    public void create () throws IOException {
        addFile ();
    }

    void addFile () throws IOException {
        List files = SelectModulesPanel.selectNbmFiles();
        
        if ( files != null ) {
            File[] allFiles = new File[ files.size() ];
            Iterator it = files.iterator();
            for ( int i = 0; it.hasNext(); i++ ) {
                File fn = (File)it.next();
                if ( fn != null ) {
                    allFiles[i] = fn;                    
                }
            }
            XMLUpdates updates = new XMLUpdates( allFiles );
            HashMap allUpdates = new HashMap();
            allUpdates.put(this, updates);
            Wizard wiz = Wizard.go( allUpdates, 1 );
            if ( wiz != null ) {
                updates.checkDownloadedModules();
                wiz.refreshUpdatePanel();
            }
        }
    }

}
