/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.apisupport.beanbrowser;

import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;

final class VisualizerDebugNode extends AbstractNode {
    
    VisualizerDebugNode(Node n) {
        this(Visualizer.findVisualizer(n));
    }
    
    VisualizerDebugNode(TreeNode tn) {
        super(new VisualizerChildren(tn));
        setName("Visualizer of " + tn);
        setIconBase("org/netbeans/modules/apisupport/resources/NodeExploreIcon");
    }
    
    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.apisupport.beanbrowser");
    }
    
    private static final class VisualizerChildren extends Children.Keys {
        
        private TreeNode tree;
        
        public VisualizerChildren(TreeNode n) {
            this.tree = n;
        }
        
        protected void addNotify() {
            List list = new LinkedList();
            Enumeration en = tree.children();
            while (en.hasMoreElements()) {
                list.add(en.nextElement());
            }
            setKeys(list);
        }
        
        protected void removeNotify() {
            setKeys(java.util.Collections.EMPTY_SET);
        }
        
        protected Node[] createNodes(Object key) {
            return new Node[] { new VisualizerDebugNode((TreeNode) key) };
        }
        
    }
    
}

