/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.myorg.feedreader;

import java.awt.BorderLayout;
import java.io.Serializable;
import javax.swing.ActionMap;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

final class FeedTopComponent extends TopComponent implements ExplorerManager.Provider {
    
    private static FeedTopComponent instance;
    
    private final ExplorerManager manager = new ExplorerManager();
    private final BeanTreeView view = new BeanTreeView();
    
    private FeedTopComponent() {
        setName(NbBundle.getMessage(FeedTopComponent.class, "CTL_FeedTopComponent"));
        setToolTipText(NbBundle.getMessage(FeedTopComponent.class, "HINT_FeedTopComponent"));
        setIcon(Utilities.loadImage("org/myorg/feedreader/rss16.gif", true));
        setLayout(new BorderLayout());
        add(view, BorderLayout.CENTER);
        view.setRootVisible(true);
        try {
            manager.setRootContext(new RssNode.RootRssNode());
        } catch (DataObjectNotFoundException ex) {
            ErrorManager.getDefault().notify(ex);
        }
        ActionMap map = getActionMap();
        map.put("delete", ExplorerUtils.actionDelete(manager, true));
        associateLookup(ExplorerUtils.createLookup(manager, map));
    }
    
    public static synchronized FeedTopComponent getDefault() {
        if (instance == null) {
            instance = new FeedTopComponent();
        }
        return instance;
    }
    
    public int getPersistenceType() {
        return TopComponent.PERSISTENCE_ALWAYS;
    }
    
    protected String preferredID() {
        return "FeedTopComponent";
    }
    
    protected Object writeReplace() {
        return new ResolvableHelper();
    }
    
    private static final class ResolvableHelper implements Serializable {
        
        private static final long serialVersionUID = 1L;
        
        public Object readResolve() {
            return FeedTopComponent.getDefault();
        }
        
    }
    
    public ExplorerManager getExplorerManager() {
        return manager;
    }
    
}
