#!/bin/sh
# The contents of this file are subject to the terms of the Common Development
# and Distribution License (the License). You may not use this file except in
# compliance with the License.
#
# You can obtain a copy of the License at http://www.netbeans.org/cddl.html
# or http://www.netbeans.org/cddl.txt.
# 
# When distributing Covered Code, include this CDDL Header Notice in each file
# and include the License file at http://www.netbeans.org/cddl.txt.
# If applicable, add the following below the CDDL Header, with the fields
# enclosed by brackets [] replaced by your own identifying information:
# "Portions Copyrighted [year] [name of copyright owner]"
#
# The Original Software is NetBeans. The Initial Developer of the Original
# Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
# Microsystems, Inc. All Rights Reserved.

IDE_PORT=8000
IDE_SUSPEND=y
PARSE_NEXT=1

# Pass path to regular runide.sh as first argument.
runidesh="$1"
shift

while [ $# -gt 0 -a $PARSE_NEXT = "1" ] ; do
	case "$1" in 
		-port) shift; if [ $# -gt 0 ] ; then IDE_PORT=$1 ; shift ; fi;;
		-nowait) shift; IDE_SUSPEND=n ;;
		*) PARSE_NEXT=0 ;;
		
	esac
done
echo Waiting on port $IDE_PORT

#start the ide for a debugger
#use socket transport, port 8000, wait for an incoming connection, suspend=y is default
"$runidesh" -J-Xdebug -J-Xrunjdwp:transport=dt_socket,server=y,address=$IDE_PORT,suspend=$IDE_SUSPEND "$@"
