/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;

/**
 *
 * @author pzajac
 */
public class BasicCustomizerUtil {
    public static Map getPanels (BasicCustomizer customizer) {
        return customizer.panels;
    }
    public static ProjectCustomizer.Category[] getCategories(BasicCustomizer customizer) {
        return customizer.categories;
    }
    public static void closeButton(BasicCustomizer customizer) throws InterruptedException, InvocationTargetException {
        final WindowListener listener = (WindowListener)customizer.optionListener;
        if (listener != null) {
            SwingUtilities.invokeAndWait(new Runnable() { 
                public void run() {
                    listener.windowClosing(null);
                    listener.windowClosed(null);
                }
            }); 
        }
    }
    
    public static void okButton(BasicCustomizer customizer) throws InterruptedException, InvocationTargetException {
       final ActionListener listener = customizer.optionListener;
       if (listener != null) {
           SwingUtilities.invokeAndWait(new Runnable() {
               public void run() {
                   listener.actionPerformed(null);
               }
           });
       }
    } 
} 
