/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.apisupport.project;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.junit.NbTestCase;
import org.netbeans.modules.apisupport.project.QAUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.BasicCustomizerUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.CustomizerProviderImpl;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.filesystems.FileUtil;

/**
 * Test functionality of ProjectCustomizer.
 * @author pzajac
 */
public abstract class ProjectCustomizerHid extends NbTestCase {
    protected String categoryName;
    protected JPanel panel;
    protected ProjectCustomizer.Category category;
    protected CustomizerProviderImpl customizer;
    protected String projectName;
    
    public ProjectCustomizerHid(String name,String categoryName,String projectName) {
        super(name);
        this.categoryName = categoryName;
        this.projectName = projectName;
        
    }
    
    /** get the module project handler 
     */
    public NbModuleProject getProject() throws IOException {
        File projectDir = new File(getDataDir(),projectName); 
        return  (NbModuleProject)ProjectManager.getDefault().findProject(FileUtil.toFileObject(projectDir));
        
    }
    
    protected void setUp() throws Exception {
        customizer = (CustomizerProviderImpl) getProject().getLookup().lookup(CustomizerProviderImpl.class);
        SwingUtilities.invokeAndWait(new Runnable() {
            public void run() {
                customizer.showCustomizer(categoryName);
                Map panels = BasicCustomizerUtil.getPanels(customizer);
                ProjectCustomizer.Category categories[] = BasicCustomizerUtil.getCategories(customizer);

                for (int catIt = 0 ; catIt < categories.length ; catIt++) {
                    JPanel panel = (JPanel)panels.get(categories[catIt]);
                    ProjectCustomizer.Category category = categories[catIt];
                    if (category.getName().equals(categoryName)) {
                        ProjectCustomizerHid.this.panel = panel;
                        ProjectCustomizerHid.this.category = category;
                        break;
                    }
                }
            }
        });
    }
    protected void tearDown() throws Exception {
        closeButton();
    }
    

    public Component getComponent (String accesibleName,Class clazz,int index) {
        return QAUtil.getComponent(panel,accesibleName,clazz,index);
    }

    public Component getComponent(String accesibleName,Class clazz) {
        return getComponent(accesibleName,clazz,0);
    }
//    public void getComponent(String accesibleName,Class clazz,List matches) {
//       Component components[] = (Component[]) panel.getComponents();
//        for (int cIt = 0 ; cIt < components.length ; cIt++) {
//           Util.getComponents(components[cIt],accesibleName,clazz,matches);
//        }
//    }
    
    public void closeButton() throws Exception {
        BasicCustomizerUtil.closeButton(customizer); 
    }
    
    public void okButton() throws Exception {
        BasicCustomizerUtil.okButton(customizer);
    }
    
    public void openCustomizer() {
        customizer.showCustomizer(categoryName);
    }
    
    public void showComponents() {
        System.out.println("\n\nCategory:" + category.getName());
            QAUtil.showComponents(panel); 
    }
    
   
    

} 
    
    

//[ideTestRunner] Category:Sources
//
//
//
//[ideTestRunner] Category:Display
//[ideTestRunner] AN="Display Name:"
//[ideTestRunner] CN="class javax.swing.JLabel"
//[ideTestRunner] AN="Display Name:"
//[ideTestRunner] CN="class javax.swing.JTextField"
//[ideTestRunner] AN="Display Category:"
//[ideTestRunner] CN="class javax.swing.JLabel"
//[ideTestRunner] AN="Display Category:"
//[ideTestRunner] CN="class javax.swing.JComboBox"
//[ideTestRunner] AN="Short Description:"
//[ideTestRunner] CN="class javax.swing.JLabel"
//[ideTestRunner] AN="Short Description:"
//[ideTestRunner] CN="class javax.swing.JTextField"
//[ideTestRunner] AN="Long Description:"
//[ideTestRunner] CN="class javax.swing.JLabel"
//[ideTestRunner] AN="null"
//[ideTestRunner] CN="class javax.swing.JPanel"
//
//
//[ideTestRunner] Category:Versioning
//[ideTestRunner] AN="Code Name Base:"
//[ideTestRunner] CN="class javax.swing.JLabel"
//[ideTestRunner] AN="Code Name Base:"
//[ideTestRunner] CN="class javax.swing.JTextField"
//[ideTestRunner] AN="Major Release Version:"
//[ideTestRunner] CN="class javax.swing.JLabel"
//[ideTestRunner] AN="Major Release Version:"
//[ideTestRunner] CN="class javax.swing.JTextField"
//[ideTestRunner] AN="Specification Version:"
//[ideTestRunner] CN="class javax.swing.JLabel"
//[ideTestRunner] AN="Specification Version:"
//[ideTestRunner] CN="class javax.swing.JTextField"
//[ideTestRunner] AN="Implementation Version"
//[ideTestRunner] CN="class javax.swing.JLabel"
//[ideTestRunner] AN="Module Type:"
//[ideTestRunner] CN="class javax.swing.JTextField"
//[ideTestRunner] AN="Provided Tokens:"
//[ideTestRunner] CN="class javax.swing.JLabel"
//[ideTestRunner] AN="Provided Tokens:"
//[ideTestRunner] CN="class javax.swing.JTextField"
//[ideTestRunner] AN="Append Implementation Versions Automatically"
//[ideTestRunner] CN="class javax.swing.JCheckBox"
//[ideTestRunner] AN="Public Packages:"
//[ideTestRunner] CN="class javax.swing.JLabel"
//[ideTestRunner] AN="null"
//[ideTestRunner] CN="class javax.swing.JScrollPane"
//[ideTestRunner] AN="null"
//[ideTestRunner] CN="class javax.swing.JPanel"
//[ideTestRunner] AN="Export Packages Only to Friends:"
//[ideTestRunner] CN="class javax.swing.JCheckBox"
//[ideTestRunner] AN="null"
//[ideTestRunner] CN="class javax.swing.JPanel"

    
