<?xml version="1.0" encoding="UTF-8"?>
<!--
The contents of this file are subject to the terms of the Common Development
and Distribution License (the License). You may not use this file except in
compliance with the License.

You can obtain a copy of the License at http://www.netbeans.org/cddl.html
or http://www.netbeans.org/cddl.txt.

When distributing Covered Code, include this CDDL Header Notice in each file
and include the License file at http://www.netbeans.org/cddl.txt.
If applicable, add the following below the CDDL Header, with the fields
enclosed by brackets [] replaced by your own identifying information:
"Portions Copyrighted [year] [name of copyright owner]"

The Original Software is NetBeans. The Initial Developer of the Original
Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
Microsystems, Inc. All Rights Reserved.
-->
<!-- XXX to do:
hidden=true
instanceName, instanceClass, instanceCreate
hint.originalPublicID
helpID
simple=false
parse .settings files? hmm, will fail if link is broken though
descriptions of folders: Actions, Menu, Toolbars, UI/{Services,Runtime}, Templates, xml/{entities,lookup,memory}, ...
descriptions of file types: .instance, .settings, .shadow, .url, .ws*, ...
*_hidden
window system hierarchy: mode folder must have matching .wsmode, etc.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:output method="html"/>

    <xsl:variable name="base" select="."/><!-- XXX needs to be passed in as a param, perhaps? -->

    <xsl:template match="filesystem">
        <html>
            <head>
                <title>XML Filesystem</title>
                <style>
.attrname {
  color: #007C00;
}
.stringvalue {
  color: #99006B;
}
.numvalue {}
.boolvalue {}
.charvalue {}
.file, .folder {
    margin-bottom: 0.5em;
}
.foldername, .filename {
    font-weight: bold;
    color: #BB0000;
}
.order {}
.children {
    /* margin-left: 3em; */
}
.rootchildren {}
.attrs {
    margin-left: 1em;
}
.prefix {
    color: #555555;
}
.info {
    font-style: italic;
}
                </style>
            </head>
        </html>
        <body>
            <!--<p>Base href: '<xsl:value-of select="$base"/>'</p>-->
            <h1>An XML Filesystem</h1>
            <p>
                For information on the syntax and semantics of XML layers, see the
                <a href="http://openide.netbeans.org/">Open APIs</a>.
            </p>
            <div class="folder">
                <a name=""/>
                <xsl:call-template name="_attrs">
                    <xsl:with-param name="prefix" select="''"/>
                </xsl:call-template>
            </div>
            <xsl:call-template name="_children">
                <xsl:with-param name="prefix" select="''"/>
            </xsl:call-template>
        </body>
    </xsl:template>

    <xsl:template match="folder">
        <xsl:param name="prefix"/>
        <xsl:if test="$prefix = ''">
            <hr/>
        </xsl:if>
        <div class="folder">
            <a name="{concat($prefix, @name)}">
                <font class="prefix"><xsl:value-of select="$prefix"/></font>
                <font class="foldername"><xsl:value-of select="@name"/>/</font>
            </a>
            <br/>
            <xsl:call-template name="_attrs">
                <xsl:with-param name="prefix" select="$prefix"/>
            </xsl:call-template>
        </div>
        <xsl:call-template name="_children">
            <xsl:with-param name="prefix" select="$prefix"/>
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="file">
        <xsl:param name="prefix"/>
        <div class="file">
            <a name="{concat($prefix, @name)}">
                <font class="prefix"><xsl:value-of select="$prefix"/></font>
                <xsl:choose>
                    <xsl:when test="@url">
                        <xsl:variable name="physurl">
                            <xsl:call-template name="urlconvert">
                                <xsl:with-param name="url" select="@url"/>
                            </xsl:call-template>
                        </xsl:variable>
                        <a href="{$physurl}">
                            <font class="filename"><xsl:value-of select="@name"/></font>
                        </a>
                    </xsl:when>
                    <xsl:otherwise>
                        <font class="filename"><xsl:value-of select="@name"/></font>
                    </xsl:otherwise>
                </xsl:choose>
            </a>
            <br/>
            <xsl:call-template name="_attrs">
                <xsl:with-param name="prefix" select="$prefix"/>
            </xsl:call-template>
        </div>
    </xsl:template>

    <xsl:template match="attr">
        <xsl:param name="path"/>
        <xsl:choose>
            <xsl:when test="contains(@name, '/') and @boolvalue = 'true'">
                <font class="info">
                    Relative order:
                </font>
                <font class="order">
                    <xsl:value-of select="substring-before(@name, '/')"/>
                </font>
                <font class="info">
                    must precede
                </font>
                <font class="order">
                    <xsl:value-of select="substring-after(@name, '/')"/>
                </font>
            </xsl:when>
            <xsl:when test="@name = 'SystemFileSystem.localizingBundle' and @stringvalue">
                <font class="info">
                    Display name: value of key
                </font>
                '<xsl:value-of select="$path"/>'
                <font class="info">
                    in
                </font>
                <!-- XXX hyperlink when $base defined -->
                <xsl:value-of select="translate(@stringvalue, '.', '/')"/>.properties
            </xsl:when>
            <xsl:when test="@name = 'SystemFileSystem.icon' and @urlvalue">
                <xsl:variable name="physurl">
                    <xsl:call-template name="urlconvert">
                        <xsl:with-param name="url" select="@urlvalue"/>
                    </xsl:call-template>
                </xsl:variable>
                <font class="info">
                    Icon:
                </font>
                <img src="{$physurl}"/>
                <xsl:text> </xsl:text>[<xsl:call-template name="attrvalue"/>]
            </xsl:when>
            <xsl:when test="@name = 'originalFile' and @stringvalue and contains(../@name, '.shadow') and not(../attr[@name = 'originalFileSystem'])">
                <font class="info">
                    This is a link to
                </font>
                <a href="#{@stringvalue}"><xsl:value-of select="@stringvalue"/></a>
            </xsl:when>
            <xsl:when test="@name = 'template' and @boolvalue = 'true' and starts-with($path, 'Templates/')">
                <font class="info">
                    This file is a template
                </font>
            </xsl:when>
            <xsl:when test="@name = 'templateWizardURL' and @urlvalue and (starts-with($path, 'Templates/') or $path = 'Templates')">
                <xsl:variable name="physurl">
                    <xsl:call-template name="urlconvert">
                        <xsl:with-param name="url" select="@urlvalue"/>
                    </xsl:call-template>
                </xsl:variable>
                <font class="info">
                    This template or template folder has an accompanying
                    <a href="{$physurl}">HTML description</a>
                </font>
            </xsl:when>
            <xsl:when test="@name = 'templateWizardIterator' and starts-with($path, 'Templates/')">
                <font class="info">
                    This template really runs a wizard with the TemplateWizard.Iterator given by
                </font>
                <xsl:call-template name="attrvalue"/>
            </xsl:when>
            <xsl:otherwise>
                <font class="attrname"><xsl:value-of select="@name"/></font> =
                <xsl:call-template name="attrvalue"/>
            </xsl:otherwise>
        </xsl:choose>
        <br/>
    </xsl:template>

    <xsl:template name="attrvalue">
        <xsl:choose>
            <xsl:when test="@stringvalue">
                <font class="stringvalue">"<xsl:value-of select="@stringvalue"/>"</font>
            </xsl:when>
            <xsl:when test="@bytevalue">
                <font class="numvalue"><xsl:value-of select="@bytevalue"/></font>
            </xsl:when>
            <xsl:when test="@shortvalue">
                <font class="numvalue"><xsl:value-of select="@shortvalue"/></font>
            </xsl:when>
            <xsl:when test="@intvalue">
                <font class="numvalue"><xsl:value-of select="@intvalue"/></font>
            </xsl:when>
            <xsl:when test="@longvalue">
                <font class="numvalue"><xsl:value-of select="@longvalue"/></font>
            </xsl:when>
            <xsl:when test="@floatvalue">
                <font class="numvalue"><xsl:value-of select="@floatvalue"/></font>
            </xsl:when>
            <xsl:when test="@doublevalue">
                <font class="numvalue"><xsl:value-of select="@doublevalue"/></font>
            </xsl:when>
            <xsl:when test="@boolvalue">
                <font class="boolvalue"><xsl:value-of select="@boolvalue"/></font>
            </xsl:when>
            <xsl:when test="@charvalue">
                <font class="charvalue">'<xsl:value-of select="@charvalue"/>'</font>
            </xsl:when>
            <xsl:when test="@urlvalue">
                <xsl:variable name="physurl">
                    <xsl:call-template name="urlconvert">
                        <xsl:with-param name="url" select="@urlvalue"/>
                    </xsl:call-template>
                </xsl:variable>
                <!-- XXX styles -->
                new URL("<a href="{$physurl}"><xsl:value-of select="@urlvalue"/></a>")
            </xsl:when>
            <xsl:when test="@methodvalue">
                <!-- XXX styles -->
                <xsl:value-of select="@methodvalue"/>()
            </xsl:when>
            <xsl:when test="@newvalue">
                <!-- XXX styles -->
                new <xsl:value-of select="@newvalue"/>()
            </xsl:when>
            <xsl:when test="@serialvalue">
                <!-- XXX styles -->
                &lt;<xsl:value-of select="translate(@serialvalue, 'abcdef', 'ABCDEF')"/>&gt;
            </xsl:when>
            <xsl:otherwise>
                <xsl:message>Unknown attr type for attr <xsl:value-of select="@name"/>!</xsl:message>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="_children">
        <xsl:param name="prefix"/>
        <xsl:variable name="subprefix">
            <xsl:if test="@name">
                <xsl:value-of select="$prefix"/><xsl:value-of select="@name"/>
                <xsl:text>/</xsl:text>
            </xsl:if>
        </xsl:variable>
        <div>
            <xsl:attribute name="class">
                <xsl:choose>
                    <xsl:when test="@name">children</xsl:when>
                    <xsl:otherwise>rootchildren</xsl:otherwise>
                </xsl:choose>
            </xsl:attribute>
            <xsl:apply-templates select="file|folder">
                <xsl:sort select="@name"/>
                <xsl:with-param name="prefix" select="$subprefix"/>
            </xsl:apply-templates>
        </div>
    </xsl:template>

    <xsl:template name="_attrs">
        <xsl:param name="prefix"/>
        <xsl:variable name="path" select="concat($prefix, @name)"/>
        <div class="attrs">
            <xsl:apply-templates select="attr">
                <xsl:sort select="@name"/>
                <xsl:with-param name="path" select="$path"/>
            </xsl:apply-templates>
        </div>
    </xsl:template>

    <xsl:template name="urlconvert">
        <xsl:param name="url"/>
        <xsl:choose>
            <xsl:when test="$base and starts-with($url, 'nbres:/')">
                <xsl:value-of select="$base"/>
                <xsl:value-of select="substring-after($url, 'nbres:/')"/>
            </xsl:when>
            <xsl:when test="$base and starts-with($url, 'nbresloc:/')">
                <xsl:value-of select="$base"/>
                <xsl:value-of select="substring-after($url, 'nbresloc:/')"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$url"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>
