/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.gui.ant;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import org.netbeans.jellytools.JellyTestCase;
import org.netbeans.jellytools.EditorOperator;
import org.netbeans.jellytools.actions.SaveAllAction;
import org.netbeans.jellytools.actions.CopyAction;
import org.netbeans.jellytools.actions.PasteAction;
import org.netbeans.jellytools.actions.CutAction;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jellytools.modules.ant.nodes.AntScriptNode;
import org.netbeans.jellytools.modules.ant.nodes.AntTargetNode;
import org.netbeans.jellytools.modules.ant.SelectATaskDialog;

/**
 *
 * @author mk97936
 */
public class TestVisualEdit extends JellyTestCase {
        
    String scriptsMountPath;
    
    public TestVisualEdit(String testName) {
        super(testName);
    }

    /*
    public static Test suite() {
        TestSuite suite = new NbTestSuite(TestVisualEdit.class);
        
//        TestSuite suite = new NbTestSuite();
//        suite.addTest(new TestVisualEdit("testCopyCutPaste"));
        
//        TestSetup setup = new TestSetup(suite) {
//            protected void setUp() {
//                if (MainWindowOperator.getDefault().isMDI()) {
//                    String welcomeTitle = Bundle.getStringTrimmed("org.netbeans.modules.welcome.Bundle", 
//                                                                  "LBL_Tab_Title");
//                    EditorOperator ewo = new EditorOperator(welcomeTitle);
//                    ewo.close();
//                }
//            }
//            protected void tearDown() {
//            }
//        };
//        return setup;
        return suite;
    }
     */
    
    public void setUp() {                
        scriptsMountPath = TestUtilities.getMountPointForPkg("org.netbeans.test.gui.ant"); // NOI18N
    }
    
    // -------------------------------------------------------------------------
    
    /** TEST METHOD
     * Copy/Cut/Paste/Delete actions on ant script nodes in Explorer
     */
    public void testCopyCutPaste() {
                
        TestUtilities.newFromTemplate("Project.xml", "BlankCopyPaste", scriptsMountPath + "|" + "Output"); // NOI18N
        TestUtilities.newFromTemplate("SampleProject.xml", "SampleCopyPaste", scriptsMountPath + "|" + "Output"); // NOI18N
        
////        ExplorerOperator expl = new ExplorerOperator();
////        expl.selectPageFilesystems();
        
        AntTargetNode sampleScriptNode = new AntTargetNode(scriptsMountPath + "|" + "Output" + "|" + "SampleCopyPaste"); // NOI18N
        AntTargetNode blankScriptNode = new AntTargetNode(scriptsMountPath + "|" + "Output" + "|" + "BlankCopyPaste"); // NOI18N

        // Copy init target from Sample to Blank
        new CopyAction().perform(new Node(sampleScriptNode, "init"));
        new PasteAction().perform(blankScriptNode);
        // Cut clean target from Sample to Blank
        new CutAction().perform(new Node(sampleScriptNode, "clean"));
        new PasteAction().perform(blankScriptNode);
        // Copy javadoc target from Sample to Blank
        new CopyAction().perform(new Node(sampleScriptNode, "javadoc"));
        new PasteAction().perform(blankScriptNode);
        // Copy clean target from from Blank to Sample
        new CopyAction().perform(new Node(blankScriptNode, "clean"));
        new PasteAction().perform(sampleScriptNode);
        // Cut javadoc target from Blank to Sample
        new CutAction().perform(new Node(blankScriptNode, "javadoc"));
        new PasteAction().perform(sampleScriptNode);
        // Delete test target from Sample
//        new DeleteAction().perform(new Node(sampleScriptNode, "test"));
        
//        NbDialogOperator confirmDialog = new NbDialogOperator("Confirm Object Deletion");
//        confirmDialog.yes();
        
        new SaveAllAction().perform();

        try {
            assertFile(new File(scriptsMountPath + File.separator + "Output" + File.separator + "SampleCopyPaste.xml"), 
                       new File(getGoldenFile().getParentFile(), "SampleCopyPaste.pass"), 
                       new File(getWorkDir(), "SampleCopyPaste.diff"));
            assertFile(new File(scriptsMountPath + File.separator + "Output" + File.separator + "BlankCopyPaste.xml"), 
                       new File(getGoldenFile().getParentFile(), "BlankCopyPaste.pass"), 
                       new File(getWorkDir(), "BlankCopyPaste.diff"));
        } catch (IOException ioe) {
            ioe.printStackTrace();
        }
        
    }
    
    /** TEST METHOD
     * Adds to target all possible subelements and couple of tasks
     */
    public void testAddToTarget() {

        TestUtilities.newFromTemplate("Project.xml", "AddToTarget", scriptsMountPath + "|" + "Output");

        AntTargetNode atn = new AntTargetNode(scriptsMountPath  + "|" + "Output"+ "|" + "AddToTarget" + "|" + "all");
        
        atn.addFilelist();
        atn.addFilterset();
        atn.addMapper();
        atn.addPath();
        atn.addPatternset();

        atn.addTask(SelectATaskDialog.ITEM_COPY);
        atn.addTask(SelectATaskDialog.ITEM_JAVAC);
        atn.addTask(SelectATaskDialog.ITEM_DELETE);

        new SaveAllAction().perform();
        
        try {
            assertFile(new File(scriptsMountPath + File.separator + "Output" + File.separator + "AddToTarget.xml"), 
                       getGoldenFile(), new File(getWorkDir(), "AddToTarget.diff"));            
        } catch (IOException ioe) {
            ioe.printStackTrace();
        }
        
    }
    
    /** TEST METHOD
     * Adds to project all possible project's subelements
     */
    public void testAddToProject() {

        TestUtilities.newFromTemplate("Project.xml", "AddToProject", scriptsMountPath + "|" + "Output"); // NOI18N
        
        AntScriptNode asn = new AntScriptNode(scriptsMountPath  + "|" + "Output"+ "|" + "AddToProject"); // NOI18N

        asn.addTarget();
        asn.addProperty();
        asn.addTaskdef();
        asn.addDescription();
        asn.addFilelist();
        //asn.addFileset();
        asn.addFilterset();
        asn.addMapper();
        asn.addPath();
        asn.addPatternset();
        
        new SaveAllAction().perform();
        
        try {            
            assertFile(new File(scriptsMountPath  + File.separator + "Output" + File.separator + "AddToProject.xml"), 
                       getGoldenFile(), new File(getWorkDir(), "AddToProject.diff"));
        } catch (IOException ioe) {
            ioe.printStackTrace();
        }
        
    }
    
    /** TEST METHOD
     * 
     */
    public void testEditor() {
        
        TestUtilities.newFromTemplate("Project.xml", "TestEdit", scriptsMountPath + "|" + "Output"); // NOI18N
        
        EditorOperator eo = new EditorOperator("TestEdit"); // NOI18N
        
        eo.delete(4, 9, 77);
        eo.insert("<property name=\"propName\" value=\"propValue\"/>\n    ", 3, 5);
        eo.insert("<javac/>\n        <mkdir dir=\"mydir\"/>\n", 5, 9);
        eo.insert("\n    <target name=\"target1\">\n", 7, 14);
        eo.insert("        <delete>\n");
        eo.insert("        </delete>\n");
        eo.insert("        <copy>\n");
        eo.insert("        </copy>\n");
        eo.insert("    </target>");
                
        new SaveAllAction().perform();
        
        log(eo.getText());
        
        HashSet hs_allOrig = new HashSet();
        hs_allOrig.add("javac");
        hs_allOrig.add("mkdir");
        
        HashSet hs_target1Orig = new HashSet();
        hs_target1Orig.add("delete");
        hs_target1Orig.add("copy");
        
        AntTargetNode atn_all = new AntTargetNode(scriptsMountPath  + "|" + "Output" + "|" + "TestEdit" + "|" + "all"); // NOI18N
        String [] atn_allChildren = atn_all.getChildren();
        HashSet hs_all = new HashSet();
        for (int i = 0; i < atn_allChildren.length; i++) {            
            hs_all.add(atn_allChildren[i]);
        }
        assertEquals("Subnodes of target \"all\" are not correct!", hs_allOrig, hs_all);
        
        AntTargetNode atn_target1 = new AntTargetNode(scriptsMountPath + "|" + "Output" + "|" + "TestEdit" + "|" + "target1"); // NOI18N
        String [] atn_target1Children = atn_target1.getChildren();
        HashSet hs_target1 = new HashSet();
        for (int i = 0; i < atn_target1Children.length; i++) {            
            hs_target1.add(atn_target1Children[i]);
        }
        assertEquals("Subnodes of target \"target1\" are not correct!", hs_target1Orig, hs_target1); // NOI18N
        
    }
    
}
