/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * TestTemplates.java
 * NetBeans JUnit based test
 *
 * Created on February 14, 2002, 5:44 PM
 */

package org.netbeans.test.gui.ant;

import junit.framework.*;
import junit.extensions.TestSetup;

import org.netbeans.junit.*;

import org.netbeans.jellytools.JellyTestCase;

import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.EditorOperator;
import org.netbeans.jellytools.MainWindowOperator;
import org.netbeans.jellytools.OutputOperator;
import org.netbeans.jellytools.TermOperator;

import org.netbeans.jellytools.properties.PropertySheetOperator;
import org.netbeans.jellytools.properties.Property;

import org.netbeans.jellytools.actions.PropertiesAction;
import org.netbeans.jellytools.actions.CompileAction;
import org.netbeans.jellytools.actions.CleanAction;
import org.netbeans.jellytools.actions.BuildAction;

import org.netbeans.jellytools.modules.ant.nodes.AntScriptNode;

/**
 *
 * @author mk97936
 */
public class TestCompilation extends JellyTestCase {
    
    String scriptsMountPath;
    
    public TestCompilation(java.lang.String testName) {
        super(testName);
    }
        
    public static void main(java.lang.String[] args) {
        junit.textui.TestRunner.run(suite());
    }
    
    public static Test suite() {
        TestSuite suite = new NbTestSuite(TestCompilation.class);
//        TestSetup setup = new TestSetup(suite) {
//            protected void setUp() {
//                if (MainWindowOperator.getDefault().isMDI()) {
//                    EditorOperator ewo = new EditorOperator("Welcome");
//                    ewo.close();
//                }
//            }
//            protected void tearDown() {
//            }
//        };
//        return setup;
        return suite;
    }
    
    public void setUp() {
        scriptsMountPath = TestUtilities.getMountPointForPkg("org.netbeans.test.gui.ant");
        new PropertiesAction().perform();
    }
    
    //--------------------------------------------------------------------------
    
    /** TEST METHOD
     * Sets Ant Script Compilation compiler for Sample script and compiles it
     */
    public void testSampleCompilation() {                
        
        String asCompTypeName = Bundle.getString("org.apache.tools.ant.module.run.Bundle", "LBL_CompilerType");   // NOI18N
        
        TestUtilities.newFromTemplate("SampleProject.xml", "SampleCompilation", scriptsMountPath + "|" + "Output"); // NOI18N
        
        AntScriptNode asn = new AntScriptNode(scriptsMountPath + "|" + "Output" + "|" + "SampleCompilation"); // NOI18N
        
        new PropertiesAction().perform(asn);
        PropertySheetOperator pso = new PropertySheetOperator(PropertySheetOperator.MODE_PROPERTIES_OF_ONE_OBJECT, 
                                                              "SampleCompilation"); // NOI18N
        new Property(pso, "Compiler").setValue(asCompTypeName);
        pso.close();
        
        new CompileAction().performMenu(asn);
        
        MainWindowOperator mwo = MainWindowOperator.getDefault();
        mwo.waitStatusText("Finished SampleCompilation.");
        
        OutputOperator owo = new OutputOperator();
        owo.getTerm(Bundle.getString("org.apache.tools.ant.module.run.Bundle", "TITLE_output_compilation")); // NOI18N
        String owText = owo.getText();
        
        assertTrue("Expected Compiler output hasn't been printed to Output Window.", // NOI18N
                   owText.indexOf("Finished SampleCompilation") > -1);
        owo.close();
    }

    /** TEST METHOD
     * Tests actions in Build menu on ant script, which has compiler set to Ant Script Compilation
     */
    public void testCompileBuildClean() {
        
        String owTabTitle = Bundle.getString("org.apache.tools.ant.module.run.Bundle", "TITLE_output_compilation");  // NOI18N
        String asCompTypeName = Bundle.getString("org.apache.tools.ant.module.run.Bundle", "LBL_CompilerType");   // NOI18N
        
        AntScriptNode asn = new AntScriptNode(scriptsMountPath + "|" + "CompileBuildClean");
        
        new PropertiesAction().perform(asn);
        PropertySheetOperator pso = new PropertySheetOperator(PropertySheetOperator.MODE_PROPERTIES_OF_ONE_OBJECT, 
                                                              "CompileBuildClean"); // NOI18N
        new Property(pso, "Compiler").setValue(asCompTypeName);
        pso.close();
        
        // Compile
        new CompileAction().performMenu(asn);
        MainWindowOperator mwo = MainWindowOperator.getDefault();
        mwo.waitStatusText("Finished CompileBuildClean.");
        
        OutputOperator owo = new OutputOperator();
        owo.getTerm(owTabTitle);
        String owText = owo.getText();
        
        assertTrue("Expected Compile output hasn't been printed to Output Window.", // NOI18N
                   owText.indexOf("Running all target") > -1); // NOI18N
        
        // Clean
        new CleanAction().performMenu(asn);
        mwo.waitStatusText("Finished CompileBuildClean.");
        
        owo.getTerm(owTabTitle);
        owText = owo.getText();
        
        assertTrue("Expected Clean output hasn't been printed to Output Window.", // NOI18N
                   owText.indexOf("Running clean target") > -1); // NOI18N
        
        // Build
        new BuildAction().performMenu(asn);
        mwo.waitStatusText("Finished CompileBuildClean.");
        
        owo.getTerm(owTabTitle);
        owText = owo.getText();
        
        assertTrue("Expected Build output hasn't been printed to Output Window.", // NOI18N
                   owText.indexOf("Running all target") > -1); // NOI18N
        
    }
    
}
