/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2002-2003 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * SelectATask.java
 *
 * Created on 8/23/02 3:16 PM
 */

package org.netbeans.jellytools.modules.ant;

import org.netbeans.jemmy.operators.*;
import org.netbeans.jellytools.NbDialogOperator;

/** Class implementing all necessary methods for handling "Select a Task" NbDialog.
 *
 * @author mk97936
 * @version 1.0
 */
public class SelectATaskDialog extends NbDialogOperator {

    /** Creates new SelectATask that can handle it.
     */
    public SelectATaskDialog() {
        super("Select a Task");
    }

    private JLabelOperator _lblChooseATaskToAdd;
    private JComboBoxOperator _cboChooseATaskComboBox;
    public static final String ITEM_ANT = "ant"; 
    public static final String ITEM_ANTCALL = "antcall"; 
    public static final String ITEM_ANTLR = "antlr"; 
    public static final String ITEM_ANTSTRUCTURE = "antstructure"; 
    public static final String ITEM_APPLY = "apply"; 
    public static final String ITEM_AVAILABLE = "available"; 
    public static final String ITEM_BLGENCLIENT = "blgenclient"; 
    public static final String ITEM_CAB = "cab"; 
    public static final String ITEM_CCCHECKIN = "cccheckin"; 
    public static final String ITEM_CCCHECKOUT = "cccheckout"; 
    public static final String ITEM_CCMCHECKIN = "ccmcheckin"; 
    public static final String ITEM_CCMCHECKINTASK = "ccmcheckintask"; 
    public static final String ITEM_CCMCHECKOUT = "ccmcheckout"; 
    public static final String ITEM_CCMCREATETASK = "ccmcreatetask"; 
    public static final String ITEM_CCMRECONFIGURE = "ccmreconfigure"; 
    public static final String ITEM_CCUNCHECKOUT = "ccuncheckout"; 
    public static final String ITEM_CCUPDATE = "ccupdate"; 
    public static final String ITEM_CHMOD = "chmod"; 
    public static final String ITEM_CONDITION = "condition"; 
    public static final String ITEM_COPY = "copy"; 
    public static final String ITEM_COPYDIR = "copydir"; 
    public static final String ITEM_COPYFILE = "copyfile"; 
    public static final String ITEM_CSC = "csc"; 
    public static final String ITEM_CVS = "cvs"; 
    public static final String ITEM_CVSPASS = "cvspass"; 
    public static final String ITEM_DDCREATOR = "ddcreator"; 
    public static final String ITEM_DELETE = "delete"; 
    public static final String ITEM_DELTREE = "deltree"; 
    public static final String ITEM_DEPEND = "depend"; 
    public static final String ITEM_DEPENDSET = "dependset"; 
    public static final String ITEM_EAR = "ear"; 
    public static final String ITEM_ECHO = "echo"; 
    public static final String ITEM_EJBC = "ejbc"; 
    public static final String ITEM_EJBJAR = "ejbjar"; 
    public static final String ITEM_EXEC = "exec"; 
    public static final String ITEM_EXECON = "execon"; 
    public static final String ITEM_FAIL = "fail"; 
    public static final String ITEM_FILTER = "filter"; 
    public static final String ITEM_FIXCRLF = "fixcrlf"; 
    public static final String ITEM_FTP = "ftp"; 
    public static final String ITEM_GENKEY = "genkey"; 
    public static final String ITEM_GET = "get"; 
    public static final String ITEM_GUNZIP = "gunzip"; 
    public static final String ITEM_GZIP = "gzip"; 
    public static final String ITEM_ICONTRACT = "icontract"; 
    public static final String ITEM_ILASM = "ilasm"; 
    public static final String ITEM_IPLANETEJBC = "iplanet-ejbc"; 
    public static final String ITEM_JAR = "jar"; 
    public static final String ITEM_JAVA = "java"; 
    public static final String ITEM_JAVAC = "javac"; 
    public static final String ITEM_JAVACC = "javacc"; 
    public static final String ITEM_JAVADOC = "javadoc"; 
    public static final String ITEM_JAVADOC2 = "javadoc2"; 
    public static final String ITEM_JAVAH = "javah"; 
    public static final String ITEM_JDEPEND = "jdepend"; 
    public static final String ITEM_JJTREE = "jjtree"; 
    public static final String ITEM_JLINK = "jlink"; 
    public static final String ITEM_JPCOVERAGE = "jpcoverage"; 
    public static final String ITEM_JPCOVMERGE = "jpcovmerge"; 
    public static final String ITEM_JPCOVREPORT = "jpcovreport"; 
    public static final String ITEM_JUNIT = "junit"; 
    public static final String ITEM_JUNITREPORT = "junitreport"; 
    public static final String ITEM_MAIL = "mail"; 
    public static final String ITEM_MAUDIT = "maudit"; 
    public static final String ITEM_MIMEMAIL = "mimemail"; 
    public static final String ITEM_MKDIR = "mkdir"; 
    public static final String ITEM_MMETRICS = "mmetrics"; 
    public static final String ITEM_MOVE = "move"; 
    public static final String ITEM_MPARSE = "mparse"; 
    public static final String ITEM_NATIVE2ASCII = "native2ascii"; 
    public static final String ITEM_NETREXXC = "netrexxc"; 
    public static final String ITEM_P4CHANGE = "p4change"; 
    public static final String ITEM_P4COUNTER = "p4counter"; 
    public static final String ITEM_P4EDIT = "p4edit"; 
    public static final String ITEM_P4HAVE = "p4have"; 
    public static final String ITEM_P4LABEL = "p4label"; 
    public static final String ITEM_P4REOPEN = "p4reopen"; 
    public static final String ITEM_P4REVERT = "p4revert"; 
    public static final String ITEM_P4SUBMIT = "p4submit"; 
    public static final String ITEM_P4SYNC = "p4sync"; 
    public static final String ITEM_PARALLEL = "parallel"; 
    public static final String ITEM_PATCH = "patch"; 
    public static final String ITEM_PATHCONVERT = "pathconvert"; 
    public static final String ITEM_PROPERTY = "property"; 
    public static final String ITEM_PROPERTYFILE = "propertyfile"; 
    public static final String ITEM_PVCS = "pvcs"; 
    public static final String ITEM_RECORD = "record"; 
    public static final String ITEM_RENAME = "rename"; 
    public static final String ITEM_RENAMEEXT = "renameext"; 
    public static final String ITEM_REPLACE = "replace"; 
    public static final String ITEM_RMIC = "rmic"; 
    public static final String ITEM_RPM = "rpm"; 
    public static final String ITEM_SCRIPT = "script"; 
    public static final String ITEM_SEQUENTIAL = "sequential"; 
    public static final String ITEM_SIGNJAR = "signjar"; 
    public static final String ITEM_SLEEP = "sleep"; 
    public static final String ITEM_SOUND = "sound"; 
    public static final String ITEM_SQL = "sql"; 
    public static final String ITEM_STARTEAM = "starteam"; 
    public static final String ITEM_STYLE = "style"; 
    public static final String ITEM_STYLEBOOK = "stylebook"; 
    public static final String ITEM_TAR = "tar"; 
    public static final String ITEM_TASKDEF = "taskdef"; 
    public static final String ITEM_TELNET = "telnet"; 
    public static final String ITEM_TEST = "test"; 
    public static final String ITEM_TOUCH = "touch"; 
    public static final String ITEM_TSTAMP = "tstamp"; 
    public static final String ITEM_TYPEDEF = "typedef"; 
    public static final String ITEM_UNJAR = "unjar"; 
    public static final String ITEM_UNTAR = "untar"; 
    public static final String ITEM_UNWAR = "unwar"; 
    public static final String ITEM_UNZIP = "unzip"; 
    public static final String ITEM_UPTODATE = "uptodate"; 
    public static final String ITEM_VAJEXPORT = "vajexport"; 
    public static final String ITEM_VAJIMPORT = "vajimport"; 
    public static final String ITEM_VAJLOAD = "vajload"; 
    public static final String ITEM_VSSCHECKIN = "vsscheckin"; 
    public static final String ITEM_VSSCHECKOUT = "vsscheckout"; 
    public static final String ITEM_VSSGET = "vssget"; 
    public static final String ITEM_VSSHISTORY = "vsshistory"; 
    public static final String ITEM_VSSLABEL = "vsslabel"; 
    public static final String ITEM_WAR = "war"; 
    public static final String ITEM_WLJSPC = "wljspc"; 
    public static final String ITEM_WLRUN = "wlrun"; 
    public static final String ITEM_WLSTOP = "wlstop"; 
    public static final String ITEM_XMLVALIDATE = "xmlvalidate"; 
    public static final String ITEM_ZIP = "zip"; 
    private JButtonOperator _btOK;
    private JButtonOperator _btCancel;
    private JButtonOperator _btHelp;


    //******************************
    // Subcomponents definition part
    //******************************

    /** Tries to find "Choose a task to add:" JLabel in this dialog.
     * @return JLabelOperator
     */
    public JLabelOperator lblChooseATaskToAdd() {
        if (_lblChooseATaskToAdd==null) {
            _lblChooseATaskToAdd = new JLabelOperator(this, "Choose a task to add:");
        }
        return _lblChooseATaskToAdd;
    }

    /** Tries to find null JComboBox in this dialog.
     * @return JComboBoxOperator
     */
    public JComboBoxOperator cboChooseATaskComboBox() {
        if (_cboChooseATaskComboBox==null) {
            _cboChooseATaskComboBox = new JComboBoxOperator(this);
        }
        return _cboChooseATaskComboBox;
    }

    /** Tries to find "OK" JButton in this dialog.
     * @return JButtonOperator
     */
    public JButtonOperator btOK() {
        if (_btOK==null) {
            _btOK = new JButtonOperator(this, "OK");
        }
        return _btOK;
    }

    /** Tries to find "Cancel" JButton in this dialog.
     * @return JButtonOperator
     */
    public JButtonOperator btCancel() {
        if (_btCancel==null) {
            _btCancel = new JButtonOperator(this, "Cancel");
        }
        return _btCancel;
    }

    /** Tries to find "Help" JButton in this dialog.
     * @return JButtonOperator
     */
    public JButtonOperator btHelp() {
        if (_btHelp==null) {
            _btHelp = new JButtonOperator(this, "Help");
        }
        return _btHelp;
    }


    //****************************************
    // Low-level functionality definition part
    //****************************************

    /** returns selected item for cboChooseATaskComboBox
     * @return String item
     */
    public String getSelectedChooseATaskComboBox() {
        return cboChooseATaskComboBox().getSelectedItem().toString();
    }

    /** selects item for cboChooseATaskComboBox
     * @param item String item
     */
    public void selectChooseATaskComboBox(String item) {
        cboChooseATaskComboBox().selectItem(item);
    }

    /** types text for cboChooseATaskComboBox
     * @param text String text
     */
    public void typeChooseATaskComboBox(String text) {
        cboChooseATaskComboBox().typeText(text);
    }

    /** clicks on "OK" JButton
     */
    public void oK() {
        btOK().push();
    }

    /** clicks on "Cancel" JButton
     */
    public void cancel() {
        btCancel().push();
    }

    /** clicks on "Help" JButton
     */
    public void help() {
        btHelp().push();
    }


    //*****************************************
    // High-level functionality definition part
    //*****************************************

    /** Performs verification of SelectATask by accessing all its components.
     */
    public void verify() {
        lblChooseATaskToAdd();
        cboChooseATaskComboBox();
        btOK();
        btCancel();
        btHelp();
    }

    /** Performs simple test of SelectATask
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        new SelectATaskDialog().verify();
        System.out.println("SelectATask verification finished.");
    }
}

