/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.apache.tools.ant.module.wizards.shortcut;

import java.awt.Component;
import java.net.URL;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.loaders.TemplateWizard;

final class IntroPanel extends javax.swing.JPanel {

    private IntroWizardPanel wiz;
    
    /** Create the wizard panel component and set up some basic properties. */
    public IntroPanel (IntroWizardPanel wiz) {
        this.wiz = wiz;
        initComponents ();
        initAccessibility();
        // Provide a name in the title bar.
        setName (NbBundle.getMessage (IntroPanel.class, "IP_LBL_cfg_basic_opts"));
    }

    // --- VISUAL DESIGN OF PANEL ---
    
    public void requestFocus () {
        super.requestFocus ();
        customizeCheck.requestFocus ();
    }

    
    private void initAccessibility () {    
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroPanel.class, "IP_TEXT_select_how_to_install_shortcut"));
        menuCheck.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroPanel.class, "ACS_IP_LBL_add_menu_item"));
        toolbarCheck.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroPanel.class, "ACS_IP_LBL_add_toolbar_button"));
        keyboardCheck.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroPanel.class, "ACS_IP_LBL_add_kbd_shortcut"));        
        customizeCheck.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroPanel.class, "ACS_IP_LBL_cust_code_checkbox"));
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        customizeCheck = new javax.swing.JCheckBox();
        menuCheck = new javax.swing.JCheckBox();
        toolbarCheck = new javax.swing.JCheckBox();
        keyboardCheck = new javax.swing.JCheckBox();
        hintsArea = new javax.swing.JTextArea();

        setLayout(new java.awt.GridBagLayout());

        customizeCheck.setText(NbBundle.getMessage(IntroPanel.class, "IP_LBL_cust_code_checkbox"));
        customizeCheck.setMnemonic((NbBundle.getMessage(IntroPanel.class, "IP_LBL_cust_code_checkbox_mnem")).charAt(0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 0, 0);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weighty = 1.0;
        add(customizeCheck, gridBagConstraints);

        menuCheck.setText(NbBundle.getMessage(IntroPanel.class, "IP_LBL_add_menu_item"));
        menuCheck.setMnemonic((NbBundle.getMessage(IntroPanel.class, "IP_LBL_add_menu_item_mnem")).charAt(0));
        menuCheck.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                someCheckboxClicked(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 0, 0);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(menuCheck, gridBagConstraints);

        toolbarCheck.setText(NbBundle.getMessage(IntroPanel.class, "IP_LBL_add_toolbar_button"));
        toolbarCheck.setMnemonic((NbBundle.getMessage(IntroPanel.class, "IP_LBL_add_toolbar_button_mnem")).charAt(0));
        toolbarCheck.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                someCheckboxClicked(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 0, 0);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(toolbarCheck, gridBagConstraints);

        keyboardCheck.setText(NbBundle.getMessage(IntroPanel.class, "IP_LBL_add_kbd_shortcut"));
        keyboardCheck.setMnemonic((NbBundle.getMessage(IntroPanel.class, "IP_LBL_add_kbd_shortcut_mnem")).charAt(0)
        );
        keyboardCheck.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                someCheckboxClicked(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 0, 0);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(keyboardCheck, gridBagConstraints);

        hintsArea.setEditable(false);
        hintsArea.setFont(javax.swing.UIManager.getFont ("Label.font"));
        hintsArea.setText(NbBundle.getMessage(IntroPanel.class, "IP_TEXT_select_how_to_install_shortcut"));
        hintsArea.setBackground(new java.awt.Color(204, 204, 204));
        hintsArea.setLineWrap(true);
        hintsArea.setForeground(new java.awt.Color(102, 102, 153));
        hintsArea.setWrapStyleWord(true);
        hintsArea.setDisabledTextColor(javax.swing.UIManager.getColor ("Label.foreground"));
        hintsArea.setOpaque(false);
        hintsArea.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        add(hintsArea, gridBagConstraints);

    }//GEN-END:initComponents

    private void someCheckboxClicked (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_someCheckboxClicked
        wiz.fireChangeEvent ();
    }//GEN-LAST:event_someCheckboxClicked

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox customizeCheck;
    private javax.swing.JTextArea hintsArea;
    private javax.swing.JCheckBox keyboardCheck;
    private javax.swing.JCheckBox menuCheck;
    private javax.swing.JCheckBox toolbarCheck;
    // End of variables declaration//GEN-END:variables

    public static class IntroWizardPanel implements WizardDescriptor.Panel {
    
        private IntroPanel panel = null;
        private ShortcutWizard wiz = null;
        
        public void initialize(ShortcutWizard wiz) {
            this.wiz = wiz;
        }
        
        public Component getComponent () {
            return getPanel();
        }
        
        private IntroPanel getPanel() {
            if (panel == null) {
                panel = new IntroPanel(this);
            }
            return panel;
        }

        public HelpCtx getHelp () {
            return HelpCtx.DEFAULT_HELP;
        }

        public boolean isValid () {
            return getPanel().menuCheck.isSelected () ||
                   getPanel().toolbarCheck.isSelected () ||
                   getPanel().keyboardCheck.isSelected ();
        }

        private final Set listeners = new HashSet (1); // Set<ChangeListener>
        public final void addChangeListener (ChangeListener l) {
            synchronized (listeners) {
                listeners.add (l);
            }
        }
        public final void removeChangeListener (ChangeListener l) {
            synchronized (listeners) {
                listeners.remove (l);
            }
        }
        protected final void fireChangeEvent () {
            // #44409: need to update the PROP_SHOW_* flags before storeSettings is called,
            // because then it will be too late (iterator will already have progressed):
            // XXX workaround should no longer be necessary...
            storeSettings(wiz);
            Iterator it;
            synchronized (listeners) {
                it = new HashSet (listeners).iterator ();
            }
            ChangeEvent ev = new ChangeEvent (this);
            while (it.hasNext ()) {
                ((ChangeListener) it.next ()).stateChanged (ev);
            }
        }

        public void readSettings (Object settings) {
            // XXX should read checkboxes from settings... skip for now.
        }
        public void storeSettings (Object settings) {
            WizardDescriptor wiz = (WizardDescriptor) settings;
            wiz.putProperty(ShortcutWizard.PROP_SHOW_CUST, getPanel().customizeCheck.isSelected() ? Boolean.TRUE : Boolean.FALSE);
            wiz.putProperty(ShortcutWizard.PROP_SHOW_MENU, getPanel().menuCheck.isSelected() ? Boolean.TRUE : Boolean.FALSE);
            wiz.putProperty(ShortcutWizard.PROP_SHOW_TOOL, getPanel().toolbarCheck.isSelected() ? Boolean.TRUE : Boolean.FALSE);
            wiz.putProperty(ShortcutWizard.PROP_SHOW_KEYB, getPanel().keyboardCheck.isSelected() ? Boolean.TRUE : Boolean.FALSE);
        }
    }

}
