/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.ant.freeform.spi;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.junit.NbTestCase;
import org.netbeans.modules.ant.freeform.FreeformProjectGenerator;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

// XXX testActionProviderMergeSemantics

/**
 * Tests correct behaviour of merging of lookups from project natures
 * and merging of instances by LookupMerger.
 *
 * @author dk125166
 */
public class ProjectNatureTest extends NbTestCase {
    
    public ProjectNatureTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        clearWorkDir();
    }
    
    private AntProjectHelper createEmptyProject(String projectFolder, String projectName) throws Exception {
        File base = new File(getWorkDir(), projectFolder);
        base.mkdir();
        AntProjectHelper helper = FreeformProjectGenerator.createProject(base, base, projectName, null);
        return helper;
    }
    
    public void testGetLookup() throws Exception {
        AntProjectHelper h = createEmptyProject("mrg", "ee");
        JavaNature javaNature = (JavaNature)Lookup.getDefault().lookup(JavaNature.class);
        assertNotNull("found java nature", javaNature);
        WebNature webNature = (WebNature)Lookup.getDefault().lookup(WebNature.class);
        assertNotNull("found web nature", webNature);

        // first test merging of lookups without LookupMerger:
        Project p = ProjectManager.getDefault().findProject(h.getProjectDirectory());
        Lookup.Result tqr = p.getLookup().lookup(new Lookup.Template(TemplatesQuery.class));
        assertEquals("no TemplatesQuery in project yet", 0, tqr.allInstances().size());
        
        TemplatesQuery javaTemplates = new BaseTemplates(new String[]{"class", "main", "library"});
        javaNature.setLookups(new Lookup[]{Lookups.fixed(new Object[]{javaTemplates})});
        assertEquals("javaTemplates in project", 1, tqr.allInstances().size());
        
        TemplatesQuery webTemplates = new BaseTemplatesAndSomeProvider(new String[]{"class", "dd"});
        webNature.setLookups(new Lookup[]{Lookups.fixed(new Object[]{webTemplates})});
        assertEquals("webTemplates and javaTemplates in project", 2, tqr.allInstances().size());
        assertEquals("one SomeProvider", 1, p.getLookup().lookup(new Lookup.Template(SomeProvider.class)).allInstances().size());

        // test merging:
        LookupMerger lm = new TemplatesQueryMerger();
        javaNature.setLookups(new Lookup[]{Lookups.fixed(new Object[]{javaTemplates, lm})});
        assertEquals("only mergedTemplates in project: " + tqr.allInstances(), 1, tqr.allInstances().size());
        TemplatesQuery tq  = (TemplatesQuery)p.getLookup().lookup(TemplatesQuery.class);
        assertEquals("three merged templates", 4, tq.getTemplates().size());
        assertEquals("one SomeProvider", 1, p.getLookup().lookup(new Lookup.Template(SomeProvider.class)).allInstances().size());

        // test nature uninstallation:
        webNature.setLookups(new Lookup[]{Lookup.EMPTY});
        assertEquals("only javaTemplates in project", 1, tqr.allInstances().size());
        tq  = (TemplatesQuery)p.getLookup().lookup(TemplatesQuery.class);
        assertEquals("two java templates", 3, tq.getTemplates().size());
        assertEquals("no SomeProvider", 0, p.getLookup().lookup(new Lookup.Template(SomeProvider.class)).allInstances().size());
    }
    
    private static class BaseNature implements ProjectNature {
        
        private ChangeableLookup lookup = new ChangeableLookup();
        
        public BaseNature() {}

        public Lookup getLookup(Project project, AntProjectHelper projectHelper, PropertyEvaluator projectEvaluator, AuxiliaryConfiguration aux) {
            return lookup;
        }

        public void setLookups(Lookup[] lookups) {
            lookup.setLookups2(lookups);
        }
        
        public Set/*<ProjectPropertiesPanel>*/ getCustomizerPanels(Project project, AntProjectHelper projectHelper, PropertyEvaluator projectEvaluator, AuxiliaryConfiguration aux) {
            return new HashSet();
        }

        public List/*<TargetDescriptor>*/ getExtraTargets(Project project, AntProjectHelper projectHelper, PropertyEvaluator projectEvaluator, AuxiliaryConfiguration aux) {
            return new ArrayList();
        }

        public Set/*<String>*/ getSchemas() {
            return new HashSet();
        }

        public Set/*<String>*/ getSourceFolderViewStyles() {
            return new HashSet();
        }

        public Node createSourceFolderView(Project project, FileObject folder, String style, String name, String displayName) throws IllegalArgumentException {
            return null;
        }

        public Node findSourceFolderViewPath(Project project, Node root, Object target) {
            return null;
        }
        
    }

    public static class JavaNature extends BaseNature {
        public JavaNature() {}
    }
    
    public static class WebNature extends BaseNature {
        public WebNature() {}
    }

    private static final class ChangeableLookup extends ProxyLookup {
        public ChangeableLookup() {}
        
        public void setLookups2(Lookup[] lookups) {
            setLookups(lookups);
        }
    }
    
    private interface TemplatesQuery {
        List getTemplates();
    }
    
    private static class BaseTemplates implements TemplatesQuery {
        List list = new ArrayList();
        public BaseTemplates(String arr[]) {
            list.addAll(Arrays.asList(arr));
        }
        public List getTemplates() {
            return list;
        }
    }
    
    private static class BaseTemplatesAndSomeProvider extends BaseTemplates implements SomeProvider {
        public BaseTemplatesAndSomeProvider(String arr[]) {
            super(arr);
        }
        public Object find() {
            return null;
        }
    }
    
    private interface SomeProvider {
        public Object find();
    }

    private static class TemplatesQueryMerger implements LookupMerger {
        public TemplatesQueryMerger() {}
        public Class[] getMergeableClasses() {
            return new Class[]{TemplatesQuery.class};
        }
        public Object merge(Lookup lookup, Class clazz) {
            assert clazz == TemplatesQuery.class;
            Set set = new LinkedHashSet();
            Iterator it = lookup.lookup(new Lookup.Template(TemplatesQuery.class)).allInstances().iterator();
            while (it.hasNext()) {
                TemplatesQuery tq = (TemplatesQuery)it.next();
                set.addAll(tq.getTemplates());
            }
            return new BaseTemplates((String[])set.toArray(new String[set.size()]));
        }
    }
    
}
