/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.ant.freeform.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.tree.TreeSelectionModel;
import org.netbeans.modules.ant.freeform.FreeformProject;
import org.netbeans.modules.ant.freeform.Util;
import org.netbeans.modules.ant.freeform.spi.ProjectNature;
import org.netbeans.modules.ant.freeform.spi.ProjectPropertiesPanel;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.DialogDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;


/**
 *
 * @author Petr Hrebejk, David Konecny
 */
public class ProjectCustomizer extends javax.swing.JPanel implements HelpCtx.Provider {

    private Component currentCustomizer;
    private GridBagConstraints fillConstraints;
    private List panels;
    private AntProjectHelper helper;
    private FreeformProject project;

    private DialogDescriptor dialogDescriptor;
    
    private static final String GENERAL_ICON = "general.gif"; // NOI18N
    
    public ProjectCustomizer(FreeformProject project, AntProjectHelper helper) {
        this.helper = helper;
        this.project = project;
        initComponents();
        HelpCtx.setHelpIDString( customizerPanel, "org.netbeans.modules.ant.freeform.ui.ProjectCustomizer." + Util.getMergedHelpIDFragments(project) ); // NOI18N
        
        fillConstraints = new GridBagConstraints();
        fillConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        fillConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        fillConstraints.fill = java.awt.GridBagConstraints.BOTH;
        fillConstraints.weightx = 1.0;
        fillConstraints.weighty = 1.0;

        categoryPanel.add(new CategoryView(createRootNode()), fillConstraints);
    }

    void save() {
        Iterator it = panels.iterator();
        while (it.hasNext()) {
            ProjectPropertiesPanel panel = (ProjectPropertiesPanel)it.next();
            panel.storeValues();
        }
   }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        categoryPanel = new javax.swing.JPanel();
        jPanel1 = new javax.swing.JPanel();
        customizerPanel = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();

        setLayout(new java.awt.GridBagLayout());

        setPreferredSize(new java.awt.Dimension(750, 450));
        getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ProjectCustomizer.class, "ACSD_ProjectCustomizer"));
        categoryPanel.setLayout(new java.awt.GridBagLayout());

        categoryPanel.setBorder(new javax.swing.border.EtchedBorder());
        categoryPanel.setMinimumSize(new java.awt.Dimension(220, 4));
        categoryPanel.setPreferredSize(new java.awt.Dimension(220, 4));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 8, 8, 8);
        add(categoryPanel, gridBagConstraints);
        categoryPanel.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(ProjectCustomizer.class, "ACSN_ProjectCustomizer_categoryPanel"));
        categoryPanel.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ProjectCustomizer.class, "ACSD_ProjectCustomizer_categoryPanel"));

        jPanel1.setLayout(new java.awt.GridBagLayout());

        customizerPanel.setLayout(new java.awt.GridBagLayout());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel1.add(customizerPanel, gridBagConstraints);
        customizerPanel.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(ProjectCustomizer.class, "ACSN_ProjectCustomizer_customizerPanel"));
        customizerPanel.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ProjectCustomizer.class, "ACSD_ProjectCustomizer_customizerPanel"));

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 8, 8);
        add(jPanel1, gridBagConstraints);

        jLabel1.setText(org.openide.util.NbBundle.getMessage(ProjectCustomizer.class, "LBL_Customizer_Categories"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(8, 8, 0, 0);
        add(jLabel1, gridBagConstraints);

    }//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel categoryPanel;
    private javax.swing.JPanel customizerPanel;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanel1;
    // End of variables declaration//GEN-END:variables

    public void setDialogDescriptor( DialogDescriptor dialogDescriptor ) {
        this.dialogDescriptor = dialogDescriptor;
    }
    
    // HelpCtx.Provider implementation -----------------------------------------
    
    public HelpCtx getHelpCtx() {
        if ( currentCustomizer != null ) {
            HelpCtx customizerCtx = HelpCtx.findHelp( currentCustomizer );
            if (customizerCtx.getHelpID() != null) {
                return new HelpCtx(customizerCtx.getHelpID() + "." + Util.getMergedHelpIDFragments(project)); // NOI18N
            } else {
                return customizerCtx;
            }
        } else {
            return HelpCtx.findHelp( customizerPanel );
        }
    }
    
    // Private innerclasses ----------------------------------------------------

    private class CategoryView extends JPanel implements ExplorerManager.Provider {

        private ExplorerManager manager;
        private BeanTreeView btv;

        CategoryView( Node rootNode ) {

            // See #36315
            manager = new ExplorerManager();

            setLayout( new BorderLayout() );

            Dimension size = new Dimension( 220, 4 );
            btv = new BeanTreeView();    // Add the BeanTreeView
            btv.setSelectionMode( TreeSelectionModel.SINGLE_TREE_SELECTION );
            btv.setPopupAllowed( false );
            btv.setRootVisible( false );
            btv.setDefaultActionAllowed( false );
            btv.setMinimumSize( size );
            btv.setPreferredSize( size );
            btv.setMaximumSize( size );
            btv.setDragSource (false);
            btv.setDragSource (false);
            this.add( btv, BorderLayout.CENTER );
            manager.setRootContext( rootNode );
            manager.addPropertyChangeListener( new ManagerChangeListener() );
            selectFirstNode();
            btv.expandAll();

        }

        public ExplorerManager getExplorerManager() {
            return manager;
        }

        public void addNotify() {
            super.addNotify();
            btv.expandAll();
        }

        private void selectFirstNode() {

            Children ch = manager.getRootContext().getChildren();
            if ( ch != null ) {
                Node nodes[] = ch.getNodes();

                if ( nodes != null && nodes.length > 0 ) {
                    try {
                        manager.setSelectedNodes( new Node[] { nodes[0] } );
                    }
                    catch ( PropertyVetoException e ) {
                        // No node will be selected
                    }
                }
            }

        }


        /** Listens to selection change and shows the customizers as
         *  panels
         */

        private class ManagerChangeListener implements PropertyChangeListener {

            public void propertyChange(PropertyChangeEvent evt) {
                if(evt.getSource() != manager) {
                    return;
                }

                if (ExplorerManager.PROP_SELECTED_NODES.equals(evt.getPropertyName())) {
                    Node nodes[] = manager.getSelectedNodes();
                    if ( nodes == null || nodes.length <= 0 ) {
                        return;
                    }
                    Node node = nodes[0];

                    if ( currentCustomizer != null ) {
                        customizerPanel.remove( currentCustomizer );
                    }
                    if ( node.hasCustomizer() ) {
                        currentCustomizer = node.getCustomizer();
                        customizerPanel.add( currentCustomizer, fillConstraints );
                        customizerPanel.validate();
                        customizerPanel.repaint();
                        if ( ProjectCustomizer.this.dialogDescriptor != null ) {
                            ProjectCustomizer.this.dialogDescriptor.setHelpCtx( ProjectCustomizer.this.getHelpCtx() );
                        }


                    }
                    else {
                        currentCustomizer = null;
                    }

                    return;
                }
            }
        }
    }

    // Private methods ---------------------------------------------------------

    private List/*<ProjectPropertiesPanel>*/ getProjectCustomizerPanels() {
        AuxiliaryConfiguration aux = (AuxiliaryConfiguration) project.getLookup().lookup(AuxiliaryConfiguration.class);
        AntProjectHelper helper = project.helper();
        PropertyEvaluator eval = project.evaluator();
        List/*<ProjectPropertiesPanel>*/ panels = new ArrayList();
        List/*<TargetDescriptor>*/ extraTargets = new ArrayList();
        Iterator/*<ProjectNature>*/ natures = FreeformProject.PROJECT_NATURES.allInstances().iterator();
        while (natures.hasNext()) {
            ProjectNature pn = (ProjectNature) natures.next();
            panels.addAll(pn.getCustomizerPanels(project, helper, eval, aux));
            extraTargets.addAll(pn.getExtraTargets(project, helper, eval, aux));
        }
        panels.add(new TargetMappingPanel.Panel(extraTargets, eval, helper));
        
        Collections.sort(panels, new PanelsComparator());
        return panels;
    }

    private static class PanelsComparator implements Comparator/*<ProjectPropertiesPanel>*/ {
        public int compare(Object o1, Object o2) {
            ProjectPropertiesPanel p1 = (ProjectPropertiesPanel)o1;
            ProjectPropertiesPanel p2 = (ProjectPropertiesPanel)o2;
            if (p1.getPreferredPosition() == p2.getPreferredPosition()) {
                return 0;
            } else {
                return p1.getPreferredPosition() - p2.getPreferredPosition();
            }
        }
        public boolean equals(Object obj) {
            // XXX why can't this be called?
            assert false;
            return false;
        }
    }
    
    private Node createRootNode() {

        String ICON_FOLDER = "org/netbeans/modules/ant/freeform/resources/"; // NOI18N
        ResourceBundle bundle = NbBundle.getBundle(ProjectCustomizer.class);
        
        ArrayList l = new ArrayList();
        panels = getProjectCustomizerPanels();
        Iterator it = panels.iterator();
        while (it.hasNext()) {
            ProjectPropertiesPanel panel = (ProjectPropertiesPanel)it.next();
            ConfigurationDescription cd = new ConfigurationDescription(
                panel.getDisplayName(),
                panel.getDisplayName(),
                ICON_FOLDER + GENERAL_ICON,
                panel,
                null);
            l.add(cd);
        }

        ConfigurationDescription rootDescription = new ConfigurationDescription(
        "InvisibleRoot", "InvisibleRoot", null, null, (ConfigurationDescription[])l.toArray(new ConfigurationDescription[l.size()]));  // NOI18N

        return new ConfigurationNode( rootDescription );
    }

    // Private innerclasses ----------------------------------------------------

    /** Class describing the configuration node. Prototype of the
     *  configuration node.
     */
    private static class ConfigurationDescription {


        private String name;
        private String displayName;
        private String iconResource;
        private ProjectPropertiesPanel panel;
        private ConfigurationDescription[] children;
        // XXX Add Node.Properties

        ConfigurationDescription( String name,
        String displayName,
        String iconResource,
        ProjectPropertiesPanel panel,
        ConfigurationDescription[] children ) {

            this.name = name;
            this.displayName = displayName;
            this.iconResource = iconResource;
            this.panel = panel;
            this.children = children;
        }

    }


    /** Node to be used for configuration
     */
    private static class ConfigurationNode extends AbstractNode {

        private ProjectPropertiesPanel panel;
        /** resource path to icon, or null */
        private final String iconResource;

        public ConfigurationNode( ConfigurationDescription description ) {
            super( description.children == null ? Children.LEAF : new ConfigurationChildren( description.children ) );
            setName( description.name );
            setDisplayName( description.displayName );
            this.iconResource = description.iconResource;
            this.panel = description.panel;
        }

        public boolean hasCustomizer() {
            return true;
        }

        public Component getCustomizer() {
            if (panel == null) {
                return null;
            }
            return panel.getComponent();
        }

        public Image getIcon(int type) {
            if (iconResource != null) {
                return Utilities.loadImage(iconResource, true);
            } else {
                return super.getIcon(type);
            }
        }

        public Image getOpenedIcon(int type) {
            if (iconResource != null) {
                return Utilities.loadImage(iconResource, true);
            } else {
                return super.getOpenedIcon(type);
            }
        }

    }

    /** Children used for configuration
     */
    private static class ConfigurationChildren extends Children.Keys {

        private Collection descriptions;

        public ConfigurationChildren( ConfigurationDescription[] descriptions ) {
            this.descriptions = Arrays.asList( descriptions );
        }

        // Children.Keys impl --------------------------------------------------

        public void addNotify() {
            setKeys( descriptions );
        }

        public void removeNotify() {
            setKeys( Collections.EMPTY_LIST );
        }

        protected Node[] createNodes( Object key ) {
            return new Node[] { new ConfigurationNode( (ConfigurationDescription)key ) };
        }
    }
}
