/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.ant.freeform.spi;

import javax.swing.JComponent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;

/**
 * Interface describing one customizer panel. The panels are added to
 * the project customizer by {@link ProjectNature#getCustomizerPanels}.
 * @author David Konecny
 */
public interface ProjectPropertiesPanel {

    /**
     * Returns panel to be shown in UI.
     */
    JComponent getComponent();
    
    /**
     * Returns display name of the panel which is used in the category list.
     */
    String getDisplayName();
    
    /**
     * Persists customizations done in the panel. Called only when user
     * pressed OK in customizer. The panel may or may not be retrieved
     * by getComponent() method.
     */
    void storeValues();

    /**
     * Preferred position in the list of panels at which it should be displayed.
     * Check other panels positions to sort it. When multiple panels has the same
     * position the order is undefined.
     */
    int getPreferredPosition();

    //Icon getIcon();
    
}
