<?xml version="1.0" encoding="UTF-8"?><xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" version="1.0">

  <xsl:output method="html" indent="yes"/>

  <!-- template rule matching source root element -->
  <xsl:template match="/">
    <html> <head> 
    <title>Java AVK for the Enterprise Report Tool </title>
    <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
    <LINK href="./appVerification.css" rel="stylesheet" type="text/css"> 
    </LINK>
    </meta>
    </head>

    <xsl:apply-templates select="app-verification"/>
    </html>
  </xsl:template>

  <xsl:template match="app-verification">
     <body bgcolor="#FFFFFF" background="./Lt_BluePaperTexture.gif">
     <form method="post" action="">
        <table width="100%" border="0" cellspacing="0" cellpadding="0">
           <tr bgcolor="7171A5">
             <td width="100%"> 
                <div class="page-title-text" align="left">Java AVK for the Enterprise - Application Exception Detail </div>
             </td>
           </tr>
        </table>

    <xsl:if test="count(exception) !=0">

     <table border="0" cellspacing="0" cellpadding="0" width="100%">
     <tr> 
      <td> 
        <div class="table-title-text">Application File: </div>
        <div class="table-normal-text"><xsl:value-of select="../app-name"/></div>
        <div class="table-title-text">JAR File: </div>
	<div class="table-normal-text"><xsl:value-of select="../jar-name"/></div>
        <div class="table-title-text">EJB Name: </div>
	<div class="table-normal-text"><xsl:value-of select="../bean-name"/></div>
        <div class="table-title-text">Method Signature: </div>
	<div class="table-normal-text"><xsl:value-of select="method-signature"/></div>
      </td>
     </tr>
    </table>

   <table border="0" cellspacing="0" cellpadding="1" width="100%">
    <tr> 
    <td> 

      <table class="back-table" border="0" cellspacing="0" cellpadding="0" width="100%">
        <tr>
        <td>

    <table class="front-table" border="0" cellspacing="0" cellpadding="0" width="100%">
    <xsl:for-each select="exception">
          <tr class="header-row">
            <td width="0%">
              <div class="table-header-text" align="left"/>
            </td>
            <td WIDTH="100%">
              <div class="table-header-text" align="left"/>
            </td>
          </tr>
          <tr height="1">
            <td class="line-row" colspan="2"><img src="./dot.gif" alt="" width="1" height="1" border="0"/></td>
         </tr>
          <tr>
            <td colspan="2" valign="top">
              <div class="table-bold-text" align="left">Exception Trace: </div>
            </td>
         </tr>
          <tr>
            <td width="2%" valign="top"> </td>
            <td width="98%" valign="bottom">
              <div class="table-normal-text" align="left"><xsl:value-of select=" exception-trace"/></div>
            </td>
          </tr>
          <tr>
            <td valign="top"/>
            <td valign="top">
              <div class="table-bold-text">Exception Name: </div>
            </td>
          </tr>
          <tr>
            <td width="2%" valign="top"> </td>
            <td width="98%" valign="bottom">
              <div class="table-normal-text" align="left"><xsl:value-of select=" exception-name"/></div>
            </td>
          </tr>
   </xsl:for-each>
   </table>
   </td>
   </tr>
   </table>

   </td>
   </tr>
   </table>
  </xsl:if>

     </form>
     </body>
  </xsl:template>


</xsl:stylesheet>