/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.io;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import prefuse.data.Table;
import prefuse.data.io.AbstractTableWriter;
import prefuse.data.io.DataIOException;
import prefuse.util.collections.IntIterator;

public class CSVTableWriter
extends AbstractTableWriter {
    private boolean m_printHeader;

    public CSVTableWriter() {
        this(true);
    }

    public CSVTableWriter(boolean printHeader) {
        this.m_printHeader = printHeader;
    }

    public boolean isPrintHeader() {
        return this.m_printHeader;
    }

    public void setPrintHeader(boolean printHeader) {
        this.m_printHeader = printHeader;
    }

    public void writeTable(Table table, OutputStream os) throws DataIOException {
        try {
            PrintStream out = new PrintStream(new BufferedOutputStream(os));
            if (this.m_printHeader) {
                for (int i = 0; i < table.getColumnCount(); ++i) {
                    if (i > 0) {
                        out.print(',');
                    }
                    out.print(this.makeCSVSafe(table.getColumnName(i)));
                }
                out.println();
            }
            IntIterator rows = table.rows();
            while (rows.hasNext()) {
                int row = rows.nextInt();
                for (int i = 0; i < table.getColumnCount(); ++i) {
                    if (i > 0) {
                        out.print(',');
                    }
                    String str = table.getString(row, table.getColumnName(i));
                    out.print(this.makeCSVSafe(str));
                }
                out.println();
            }
            out.flush();
        }
        catch (Exception e) {
            throw new DataIOException(e);
        }
    }

    private String makeCSVSafe(String s) {
        int q = -1;
        q = s.indexOf(34);
        if (q >= 0 || s.indexOf(44) >= 0 || s.indexOf(10) >= 0 || Character.isWhitespace(s.charAt(0)) || Character.isWhitespace(s.charAt(s.length() - 1))) {
            if (q >= 0) {
                s = s.replaceAll("\"", "\"\"");
            }
            s = "\"" + s + "\"";
        }
        return s;
    }
}

