/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.filter;

import java.util.Iterator;
import prefuse.Visualization;
import prefuse.action.GroupAction;
import prefuse.data.Graph;
import prefuse.data.expression.Predicate;
import prefuse.data.tuple.TupleSet;
import prefuse.data.util.BreadthFirstIterator;
import prefuse.data.util.FilterIterator;
import prefuse.util.PrefuseLib;
import prefuse.visual.VisualItem;
import prefuse.visual.expression.InGroupPredicate;

public class GraphDistanceFilter
extends GroupAction {
    protected int m_distance;
    protected String m_sources;
    protected Predicate m_groupP;
    protected BreadthFirstIterator m_bfs;

    public GraphDistanceFilter(String group) {
        this(group, 1);
    }

    public GraphDistanceFilter(String group, int distance) {
        this(group, Visualization.FOCUS_ITEMS, distance);
    }

    public GraphDistanceFilter(String group, String sources, int distance) {
        super(group);
        this.m_sources = sources;
        this.m_distance = distance;
        this.m_groupP = new InGroupPredicate(PrefuseLib.getGroupName(group, Graph.NODES));
        this.m_bfs = new BreadthFirstIterator();
    }

    public int getDistance() {
        return this.m_distance;
    }

    public void setDistance(int distance) {
        this.m_distance = distance;
    }

    public void run(double frac) {
        VisualItem item;
        Iterator items = this.m_vis.visibleItems(this.m_group);
        while (items.hasNext()) {
            VisualItem item2 = (VisualItem)items.next();
            item2.setDOI(-1.7976931348623157E308);
        }
        TupleSet src = this.m_vis.getGroup(this.m_sources);
        FilterIterator srcs = new FilterIterator(src.tuples(), this.m_groupP);
        this.m_bfs.init(srcs, this.m_distance, 2);
        while (this.m_bfs.hasNext()) {
            item = (VisualItem)this.m_bfs.next();
            int d = this.m_bfs.getDepth(item);
            PrefuseLib.updateVisible(item, true);
            item.setDOI(-d);
            item.setExpanded(d < this.m_distance);
        }
        items = this.m_vis.visibleItems(this.m_group);
        while (items.hasNext()) {
            item = (VisualItem)items.next();
            if (item.getDOI() != -1.7976931348623157E308) continue;
            PrefuseLib.updateVisible(item, false);
            item.setExpanded(false);
        }
    }
}

