/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.gjast;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Todo;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.parser.Parser;
import com.sun.tools.javac.parser.Scanner;
import com.sun.tools.javac.tree.Tree;
import com.sun.tools.javac.util.Abort;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Options;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Stack;
import org.netbeans.lib.gjast.ASEnter;
import org.netbeans.lib.gjast.ASIdent;
import org.netbeans.lib.gjast.ASLiteral;
import org.netbeans.lib.gjast.ASLog;
import org.netbeans.lib.gjast.ASName;
import org.netbeans.lib.gjast.ASNameTable;
import org.netbeans.lib.gjast.ASScanner;
import org.netbeans.lib.gjast.ASTopLevel;
import org.netbeans.lib.gjast.ASTreeMaker;
import org.netbeans.lib.gjast.ASTreeNode;
import org.netbeans.lib.gjast.ASTypeArray;
import org.netbeans.lib.gjast.test.DumpASTree;
import org.netbeans.lib.java.parser.ASTContext;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.CompilerException;
import org.netbeans.lib.java.parser.ErrConsumer;
import org.netbeans.lib.java.parser.JParser;
import org.netbeans.lib.java.parser.Token;

public class ASParser
implements JParser {
    private ASTree topLevel;
    private Token[] tokens;
    private Reader in;
    private String filename;
    private ASTContext astContext;
    private static final boolean dumpTrees;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ASParser(ASTContext astContext, Reader in, String filename) {
        this.in = in;
        this.filename = filename;
        if (!filename.endsWith(".java")) {
            this.filename = this.filename + ".java";
        }
        this.astContext = astContext;
    }

    public ASTree getASTree() {
        return this.topLevel;
    }

    public Token[] getTokens() {
        return this.tokens;
    }

    public int parse(boolean doAttribution) throws CompilerException {
        ParseEngine engine = new ParseEngine(this.astContext, this.in, this.filename);
        int errors = engine.parse(doAttribution);
        this.topLevel = this.genericize(engine.getTopLevel());
        this.tokens = engine.getTokens();
        if (dumpTrees) {
            DumpASTree.dump(this.filename, this, engine.getSource());
        }
        this.in = null;
        return errors;
    }

    private ASTree genericize(ASTree in) {
        if (in == null) {
            return null;
        }
        if (!$assertionsDisabled && in.getType() != 15) {
            throw new AssertionError();
        }
        this.topLevel = in;
        Stack<ASTree[]> stack = new Stack<ASTree[]>();
        ASTree out = ASParser.genericizeASTree(in);
        ASTree[] subTrees = out.getSubTrees();
        if (subTrees != null) {
            stack.push(subTrees);
        }
        while (!stack.empty()) {
            subTrees = (ASTree[])stack.pop();
            for (int i = 0; i < subTrees.length; ++i) {
                if (subTrees[i] == null) continue;
                subTrees[i] = ASParser.genericizeASTree(subTrees[i]);
                ASTree[] subsubTrees = subTrees[i].getSubTrees();
                if (subsubTrees == null) continue;
                stack.push(subsubTrees);
            }
        }
        return out;
    }

    private static ASTree genericizeASTree(ASTree in) {
        if (in == null) {
            return null;
        }
        ASTree[] subTrees = in.getSubTrees();
        int type = in.getType();
        if (subTrees == null && in instanceof Token && type != 50 && type != 49) {
            return ASParser.genericizeToken((Token)in);
        }
        return new ASTreeNode(in.getASTContext(), type, in.getFirstToken(), in.getLastToken(), subTrees, in.getSymbolInfo());
    }

    private static ASTree genericizeToken(Token in) {
        if (in instanceof ASIdent) {
            return ((ASIdent)in).getLexicalToken();
        }
        if (in instanceof ASLiteral) {
            return ((ASLiteral)in).getLexicalToken();
        }
        if (in instanceof ASName) {
            return ((ASName)in).getToken();
        }
        if (in instanceof ASTypeArray) {
            return ((ASTypeArray)in).getToken();
        }
        return in;
    }

    static char[] readInChars(Reader in) {
        char[] src;
        try {
            int n;
            CharArrayWriter out = new CharArrayWriter();
            char[] buf = new char[8192];
            while ((n = in.read(buf)) > 0) {
                out.write(buf, 0, n);
            }
            out.write(0);
            src = out.toCharArray();
        }
        catch (IOException e) {
            src = new char[1];
        }
        return src;
    }

    static {
        $assertionsDisabled = !ASParser.class.desiredAssertionStatus();
        dumpTrees = Boolean.getBoolean("gjast.dump.trees");
        if (dumpTrees) {
            File dir = new File(DumpASTree.dumpDir);
            System.out.println("dumping ASTrees to " + dir.getAbsolutePath());
        }
    }

    static class BridgeContext
    implements ASTContext {
        ASTContext delegate;
        ASScanner scanner;

        BridgeContext(ASTContext astContext) {
            this.delegate = astContext;
            this.scanner = null;
        }

        ASScanner getScanner() {
            return this.scanner;
        }

        void setScanner(ASScanner scanner) {
            this.scanner = scanner;
        }

        public ASTree getRootTree() {
            return this.delegate.getRootTree();
        }

        public String getText(ASTree tree) {
            return this.delegate.getText(tree);
        }

        public String getText(Token token) {
            return this.delegate.getText(token);
        }

        public Token getToken(int index) {
            return this.scanner != null ? (Token)this.scanner.getToken(index) : null;
        }

        public ASTree getParent(ASTree tree) {
            return this.delegate.getParent(tree);
        }

        public String getSourceLevel() {
            return this.delegate.getSourceLevel();
        }

        public String getClassPath() {
            return this.delegate.getClassPath();
        }

        public ErrConsumer getErrorConsumer() {
            return this.delegate.getErrorConsumer();
        }
    }

    static class ParseEngine
    implements ClassReader.SourceCompleter {
        private ASLog log;
        private Options opts;
        private Enter enter;
        private ASTreeMaker make;
        private ASScanner.Factory scannerFactory;
        private Parser.Factory parserFactory;
        private Name.Table names;
        private ASTopLevel topLevel;
        private Reader in;
        private String filename;
        private BridgeContext astContext;
        private ASScanner scanner;
        private Context context;
        private static final boolean errorRecovery = System.getProperty("gjast.error.recovery", "true").equals("true");

        public ParseEngine(ASTContext astContext, Reader in, String filename) {
            this.in = in;
            this.filename = filename;
            this.astContext = new BridgeContext(astContext);
        }

        public ASTree getTopLevel() {
            return this.topLevel;
        }

        public Token[] getTokens() {
            return this.scanner != null ? this.scanner.getTokens() : null;
        }

        public Token getToken(int index) {
            return this.scanner != null ? (Token)this.scanner.getToken(index) : null;
        }

        public char[] getSource() {
            return this.scanner != null ? this.scanner.getRawCharacters() : new char[]{};
        }

        public int parse(boolean doAttribution) throws CompilerException {
            try {
                this.compile(this.filename, this.in, doAttribution);
                return this.log.nerrors;
            }
            catch (Throwable t) {
                throw new CompilerException(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void complete(Symbol.ClassSymbol c, String filename, InputStream f) throws Symbol.CompletionFailure {
            ASTopLevel tree;
            ASScanner oldScanner = this.scanner;
            try {
                tree = this.parse(filename, new InputStreamReader(f));
            }
            finally {
                this.setScanner(oldScanner);
            }
            this.enter.complete(List.make(tree), c);
            if (this.enter.getEnv(c) == null) {
                throw new ClassReader.BadClassFile(c, filename, ASLog.getLocalizedString("file.doesnt.contain.class", new Object[]{c.fullname}));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void compile(String filename, Reader in, boolean doAttribution) {
            this.context = new Context();
            ASEnter.register(this.context);
            ASNameTable.register(this.context);
            this.opts = Options.instance(this.context);
            this.opts.put("-source", this.astContext.getSourceLevel());
            this.opts.put("-target", this.astContext.getSourceLevel());
            this.opts.put("-nowarn", "-nowarn");
            this.opts.put("-classpath", this.astContext.getClassPath());
            this.log = ASLog.instance(this.context);
            this.log.errConsumer(this.astContext.getErrorConsumer());
            this.make = ASTreeMaker.instance(this.context);
            this.make.setASTContext(this.astContext);
            this.scannerFactory = (ASScanner.Factory)ASScanner.Factory.instance(this.context);
            this.parserFactory = Factory.instance(this.context);
            this.names = Name.Table.instance(this.context);
            this.enter = Enter.instance(this.context);
            ClassReader reader = ClassReader.instance(this.context);
            reader.sourceCompleter = this;
            try {
                this.topLevel = this.parse(filename, in);
                if (!errorRecovery && this.log.nerrors > 0) {
                    this.topLevel = null;
                }
                if (this.log.nerrors == 0 && doAttribution) {
                    this.attribute();
                }
            }
            catch (Abort ex) {
            }
            catch (Throwable t) {
                this.log.rawError(-1, new Error("internal gjast failure", t).toString());
                t.printStackTrace();
            }
            finally {
                this.log.flush();
                reader.close();
                this.names.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int attribute() {
            Attr attr = Attr.instance(this.context);
            Todo todo = Todo.instance(this.context);
            try {
                this.enter.main(List.make(this.topLevel));
                if (todo.nonEmpty()) {
                    Env env = (Env)todo.next();
                    Name sourceName = env.enclClass.sym.sourcefile;
                    this.log.useSource(sourceName);
                    attr.attribClass(env.tree.pos, env.enclClass.sym);
                }
            }
            catch (Abort ex) {
            }
            catch (Throwable t) {
                this.log.rawError(-1, new Error("internal gjast failure", t).toString());
                t.printStackTrace();
            }
            finally {
                this.log.releaseSources();
            }
            return this.log.nerrors;
        }

        public int errorCount() {
            return this.log.nerrors;
        }

        protected ASTopLevel parse(String filename, Reader input) {
            this.make.parsing(true);
            Name sourceName = this.names.fromString(filename);
            Name prev = this.log.useSource(sourceName);
            Tree.TopLevel tree = this.make.TopLevel(Tree.Annotation.emptyList, null, Tree.emptyList);
            if (input != null) {
                char[] src = ASParser.readInChars(input);
                this.log.addSource(sourceName, src);
                this.setScanner((ASScanner)this.scannerFactory.newScanner(src, src.length - 1, true, this.astContext.delegate));
                this.make.setScanner(this.scanner);
                Parser parser = this.parserFactory.newParser(this.scanner, false);
                tree = parser.compilationUnit();
            }
            this.log.useSource(prev);
            tree.sourcefile = sourceName;
            this.make.parsing(false);
            return (ASTopLevel)tree;
        }

        private void setScanner(ASScanner scanner) {
            this.scanner = scanner;
            this.astContext.setScanner(scanner);
        }

        public static class Factory
        extends Parser.Factory {
            public static Parser.Factory instance(Context context) {
                Parser.Factory instance = (Parser.Factory)context.get(parserFactoryKey);
                if (instance == null) {
                    instance = new Factory(context);
                }
                return instance;
            }

            protected Factory(Context context) {
                super(context);
            }

            public Parser newParser(Scanner S, boolean keepDocComments) {
                return new Parser(this, S, keepDocComments){

                    protected StringBuffer foldStrings(Tree tree) {
                        return null;
                    }
                };
            }
        }
    }
}

