/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.ConstFold;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.tree.Tree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Pair;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Annotate {
    protected static final Context.Key<Annotate> annotateKey = new Context.Key();
    final Attr attr;
    final TreeMaker make;
    final Log log;
    final Symtab syms;
    final Name.Table names;
    final Resolve rs;
    final Types types;
    final ConstFold cfolder;
    final Check chk;
    private int enterCount = 0;
    ListBuffer<Annotator> q = new ListBuffer();

    public static Annotate instance(Context context) {
        Annotate instance = context.get(annotateKey);
        if (instance == null) {
            instance = new Annotate(context);
        }
        return instance;
    }

    protected Annotate(Context context) {
        context.put(annotateKey, this);
        this.attr = Attr.instance(context);
        this.make = TreeMaker.instance(context);
        this.log = Log.instance(context);
        this.syms = Symtab.instance(context);
        this.names = Name.Table.instance(context);
        this.rs = Resolve.instance(context);
        this.types = Types.instance(context);
        this.cfolder = ConstFold.instance(context);
        this.chk = Check.instance(context);
    }

    public void later(Annotator a) {
        this.q.append(a);
    }

    public void earlier(Annotator a) {
        this.q.prepend(a);
    }

    public void enterStart() {
        ++this.enterCount;
    }

    public void enterDone() {
        --this.enterCount;
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (this.enterCount != 0) {
            return;
        }
        ++this.enterCount;
        try {
            while (this.q.nonEmpty()) {
                this.q.next().enterAnnotation();
            }
        }
        finally {
            --this.enterCount;
        }
    }

    Attribute.Compound enterAnnotation(Tree.Annotation a, Type expected, Env<AttrContext> env) {
        a.type = this.chk.checkType(a.annotationType.pos, this.attr.attribType(a.annotationType, env), expected);
        if (a.type.isErroneous()) {
            return new Attribute.Compound(a.type, new List<Pair<Symbol.MethodSymbol, Attribute>>());
        }
        if ((a.type.tsym.flags() & 0x2000L) == 0L) {
            this.log.error(a.annotationType.pos, "not.annotation.type", new Object[]{a.type.toString()});
            return new Attribute.Compound(a.type, new List<Pair<Symbol.MethodSymbol, Attribute>>());
        }
        List<Tree> args = a.args;
        if (args.length() == 1 && ((Tree)args.head).tag != 30) {
            args.head = this.make.at(((Tree)args.head).pos).Assign(this.make.Ident(this.names.value), (Tree)args.head);
        }
        ListBuffer<Pair<Symbol.MethodSymbol, Attribute>> buf = new ListBuffer<Pair<Symbol.MethodSymbol, Attribute>>();
        List<Tree> tl = args;
        while (tl.nonEmpty()) {
            Tree t = (Tree)tl.head;
            if (t.tag != 30) {
                this.log.error(t.pos, "annotation.value.must.be.name.value", new Object[0]);
            } else {
                Tree.Assign assign = (Tree.Assign)t;
                if (assign.lhs.tag != 35) {
                    this.log.error(t.pos, "annotation.value.must.be.name.value", new Object[0]);
                } else {
                    Symbol method;
                    Tree.Ident left = (Tree.Ident)assign.lhs;
                    left.sym = method = this.rs.resolveQualifiedMethod(left.pos, env, a.type, left.name, Type.emptyList, null);
                    left.type = method.type;
                    if (method.owner != a.type.tsym) {
                        this.log.error(left.pos, "no.annotation.member", new Object[]{left.name, a.type});
                    }
                    Type result = method.type.restype();
                    Attribute value = this.enterAttributeValue(result, assign.rhs, env);
                    if (!method.type.isErroneous()) {
                        buf.append(new Pair<Symbol.MethodSymbol, Attribute>((Symbol.MethodSymbol)method, value));
                    }
                }
            }
            tl = tl.tail;
        }
        return new Attribute.Compound(a.type, buf.toList());
    }

    Attribute enterAttributeValue(Type expected, Tree tree, Env<AttrContext> env) {
        if (expected.isPrimitive() || this.types.isSameType(expected, this.syms.stringType)) {
            Type result = this.attr.attribExpr(tree, env, expected);
            if (result.isErroneous()) {
                return new Attribute.Error(expected);
            }
            if (result.constValue == null) {
                this.log.error(tree.pos, "attribute.value.must.be.constant", new Object[0]);
                return new Attribute.Error(expected);
            }
            result = this.cfolder.coerce(result, expected);
            return new Attribute.Constant(expected, result.constValue);
        }
        if (expected.tsym == this.syms.classType.tsym) {
            Type result = this.attr.attribExpr(tree, env, expected);
            if (result.isErroneous()) {
                return new Attribute.Error(expected);
            }
            if (TreeInfo.name(tree) != this.names._class) {
                this.log.error(tree.pos, "annotation.value.must.be.class.literal", new Object[0]);
                return new Attribute.Error(expected);
            }
            return new Attribute.Class(this.types, ((Tree.Select)tree).selected.type);
        }
        if ((expected.tsym.flags() & 0x2000L) != 0L) {
            if (tree.tag != 43) {
                this.log.error(tree.pos, "annotation.value.must.be.annotation", new Object[0]);
                expected = this.syms.errorType;
            }
            return this.enterAnnotation((Tree.Annotation)tree, expected, env);
        }
        if (expected.tag == 11) {
            if (tree.tag != 28) {
                tree = this.make.at(tree.pos).NewArray(null, Tree.emptyList, Tree.emptyList.prepend(tree));
            }
            Tree.NewArray na = (Tree.NewArray)tree;
            if (na.elemtype != null) {
                this.log.error(na.elemtype.pos, "new.not.allowed.in.annotation", new Object[0]);
                return new Attribute.Error(expected);
            }
            ListBuffer<Attribute> buf = new ListBuffer<Attribute>();
            List<Tree> l = na.elems;
            while (l.nonEmpty()) {
                buf.append(this.enterAttributeValue(this.types.elemtype(expected), (Tree)l.head, env));
                l = l.tail;
            }
            return new Attribute.Array(expected, buf.toArray(new Attribute[buf.length()]));
        }
        if (expected.tag == 10 && (expected.tsym.flags() & 0x4000L) != 0L) {
            Type result = this.attr.attribExpr(tree, env, expected);
            Symbol sym = TreeInfo.symbol(tree);
            if (sym == null || TreeInfo.nonstaticSelect(tree) || sym.kind != 4 || (sym.flags() & 0x4000L) == 0L) {
                this.log.error(tree.pos, "enum.annotation.must.be.enum.constant", new Object[0]);
                return new Attribute.Error(expected);
            }
            Symbol.VarSymbol enumerator = (Symbol.VarSymbol)sym;
            return new Attribute.Enum(expected, enumerator);
        }
        if (!expected.isErroneous()) {
            this.log.error(tree.pos, "annotation.value.not.allowable.type", new Object[0]);
        }
        return new Attribute.Error(this.attr.attribExpr(tree, env, expected));
    }

    public static interface Annotator {
        public void enterAnnotation();

        public String toString();
    }
}

