/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.util;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.parameter.Value;

public final class Dates {
    public static final long MILLIS_PER_SECOND = 1000L;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final long MILLIS_PER_WEEK = 604800000L;
    public static final int DAYS_PER_WEEK = 7;

    private Dates() {
    }

    public static int getAbsWeekNo(Date date, int n) {
        if (n == 0 || n < -53 || n > 53) {
            throw new IllegalArgumentException("Invalid week number [" + n + "]");
        }
        if (n > 0) {
            return n;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n2 = calendar.get(1);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        calendar.set(3, 1);
        while (calendar.get(1) == n2) {
            arrayList.add(new Integer(calendar.get(3)));
            calendar.add(3, 1);
        }
        return (Integer)arrayList.get(arrayList.size() + n);
    }

    public static int getAbsYearDay(Date date, int n) {
        if (n == 0 || n < -366 || n > 366) {
            throw new IllegalArgumentException("Invalid year day [" + n + "]");
        }
        if (n > 0) {
            return n;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n2 = calendar.get(1);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        calendar.set(6, 1);
        while (calendar.get(1) == n2) {
            arrayList.add(new Integer(calendar.get(6)));
            calendar.add(6, 1);
        }
        return (Integer)arrayList.get(arrayList.size() + n);
    }

    public static int getAbsMonthDay(Date date, int n) {
        if (n == 0 || n < -31 || n > 31) {
            throw new IllegalArgumentException("Invalid month day [" + n + "]");
        }
        if (n > 0) {
            return n;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n2 = calendar.get(2);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        calendar.set(5, 1);
        while (calendar.get(2) == n2) {
            arrayList.add(new Integer(calendar.get(5)));
            calendar.add(5, 1);
        }
        return (Integer)arrayList.get(arrayList.size() + n);
    }

    public static net.fortuna.ical4j.model.Date getInstance(Date date, Value value) {
        if (Value.DATE.equals(value)) {
            return new net.fortuna.ical4j.model.Date(date);
        }
        return new DateTime(date);
    }

    public static Calendar getCalendarInstance(net.fortuna.ical4j.model.Date date) {
        if (date instanceof DateTime) {
            DateTime dateTime = (DateTime)date;
            if (dateTime.getTimeZone() != null) {
                return Calendar.getInstance(dateTime.getTimeZone());
            }
            if (dateTime.isUtc()) {
                return Calendar.getInstance(TimeZone.getTimeZone("Etc/UTC"));
            }
        }
        return Calendar.getInstance(TimeZone.getTimeZone("Etc/GMT"));
    }
}

