/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.util.ParameterValidator;

public class Trigger
extends Property {
    private static final long serialVersionUID = 5049421499261722194L;
    private Dur duration;
    private DateTime dateTime;

    public Trigger() {
        super("TRIGGER");
        this.dateTime = new DateTime();
    }

    public Trigger(ParameterList parameterList, String string) {
        super("TRIGGER", parameterList);
        this.setValue(string);
    }

    public Trigger(Dur dur) {
        super("TRIGGER");
        this.setDuration(dur);
    }

    public Trigger(ParameterList parameterList, Dur dur) {
        super("TRIGGER", parameterList);
        this.setDuration(dur);
    }

    public Trigger(DateTime dateTime) {
        super("TRIGGER");
        this.dateTime = dateTime;
    }

    public Trigger(ParameterList parameterList, DateTime dateTime) {
        super("TRIGGER", parameterList);
        this.dateTime = dateTime;
    }

    public final void validate() throws ValidationException {
        if (this.getDateTime() != null) {
            ParameterValidator.getInstance().assertOne("VALUE", this.getParameters());
            Parameter parameter = this.getParameters().getParameter("VALUE");
            if (parameter == null || !Value.DATE_TIME.equals(parameter)) {
                throw new ValidationException("Parameter [" + parameter + "] is invalid");
            }
        } else {
            ParameterValidator.getInstance().assertOneOrLess("VALUE", this.getParameters());
            Parameter parameter = this.getParameters().getParameter("VALUE");
            if (parameter != null && !Value.DURATION.equals(parameter.getValue())) {
                throw new ValidationException("Parameter [VALUE=" + parameter.getValue() + "] is invalid");
            }
            ParameterValidator.getInstance().assertOneOrLess("RELATED", this.getParameters());
        }
    }

    public final DateTime getDateTime() {
        return this.dateTime;
    }

    public final Dur getDuration() {
        return this.duration;
    }

    public final void setValue(String string) {
        try {
            this.dateTime = new DateTime(string);
            this.duration = null;
        }
        catch (Exception exception) {
            this.duration = new Dur(string);
            this.dateTime = null;
        }
    }

    public final String getValue() {
        if (this.getDateTime() != null) {
            return this.getDateTime().toString();
        }
        return this.duration.toString();
    }

    public final void setDateTime(DateTime dateTime) {
        dateTime.setUtc(true);
        this.dateTime = dateTime;
        this.duration = null;
    }

    public final void setDuration(Dur dur) {
        this.duration = dur;
        this.dateTime = null;
    }
}

