/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import java.text.ParseException;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.DateProperty;
import net.fortuna.ical4j.util.ParameterValidator;

public class DtStart
extends DateProperty {
    private static final long serialVersionUID = -5707097476081111815L;

    public DtStart() {
        super("DTSTART");
    }

    public DtStart(String string) throws ParseException {
        super("DTSTART");
        this.setValue(string);
    }

    public DtStart(ParameterList parameterList, String string) throws ParseException {
        super("DTSTART", parameterList);
        this.setValue(string);
    }

    public DtStart(Date date) {
        super("DTSTART");
        this.setDate(date);
    }

    public DtStart(Date date, boolean bl) {
        super("DTSTART");
        this.setDate(date);
        this.setUtc(bl);
    }

    public DtStart(ParameterList parameterList, Date date) {
        super("DTSTART", parameterList);
        this.setDate(date);
    }

    public final void validate() throws ValidationException {
        super.validate();
        ParameterValidator.getInstance().assertOneOrLess("VALUE", this.getParameters());
        Parameter parameter = this.getParameters().getParameter("VALUE");
        if (parameter != null && !Value.DATE_TIME.equals(parameter) && !Value.DATE.equals(parameter)) {
            throw new ValidationException("Parameter [VALUE] is invalid");
        }
        if (this.isUtc()) {
            ParameterValidator.getInstance().assertNone("TZID", this.getParameters());
        } else {
            ParameterValidator.getInstance().assertOneOrLess("TZID", this.getParameters());
        }
    }
}

