/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import java.text.ParseException;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.parameter.TzId;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.util.Strings;

public abstract class DateProperty
extends Property {
    private Date date;
    protected TimeZone timezone;

    public DateProperty(String string, ParameterList parameterList) {
        super(string, parameterList);
    }

    public DateProperty(String string) {
        super(string);
    }

    public final Date getDate() {
        return this.date;
    }

    public final void setDate(Date date) {
        if (date instanceof DateTime) {
            this.setTimeZone(((DateTime)date).getTimeZone());
        }
        this.date = date;
    }

    public void setValue(String string) throws ParseException {
        this.date = Value.DATE.equals(this.getParameters().getParameter("VALUE")) ? new Date(string) : new DateTime(string, this.timezone);
    }

    public final String getValue() {
        return Strings.valueOf(this.getDate());
    }

    public final void setTimeZone(TimeZone timeZone) {
        this.timezone = timeZone;
        if (timeZone != null) {
            if (this.getDate() != null && !(this.getDate() instanceof DateTime)) {
                throw new UnsupportedOperationException("TimeZone is not applicable to current value");
            }
            if (this.getDate() != null) {
                ((DateTime)this.getDate()).setTimeZone(timeZone);
            }
            this.getParameters().remove(this.getParameters().getParameter("TZID"));
            TzId tzId = new TzId(timeZone.getID());
            this.getParameters().add(tzId);
        } else {
            this.setUtc(false);
        }
    }

    public final void setUtc(boolean bl) {
        if (this.getDate() != null && !(this.getDate() instanceof DateTime)) {
            throw new UnsupportedOperationException("UTC time is not applicable to current value");
        }
        if (this.getDate() != null) {
            ((DateTime)this.getDate()).setUtc(bl);
        }
        this.getParameters().remove(this.getParameters().getParameter("TZID"));
    }

    public final boolean isUtc() {
        if (this.getDate() instanceof DateTime) {
            return ((DateTime)this.getDate()).isUtc();
        }
        return false;
    }

    public void validate() throws ValidationException {
        super.validate();
        Value value = (Value)this.getParameters().getParameter("VALUE");
        if (value != null && !Value.DATE.equals(value) && !Value.DATE_TIME.equals(value)) {
            throw new ValidationException("Invalid VALUE parameter [" + value + "]");
        }
        if (Value.DATE.equals(value) && this.getDate() instanceof DateTime || Value.DATE_TIME.equals(value) && !(this.getDate() instanceof DateTime)) {
            throw new ValidationException("VALUE parameter [" + value + "] is invalid for date instance");
        }
        if (this.getDate() instanceof DateTime) {
            DateTime dateTime = (DateTime)this.date;
            Parameter parameter = this.getParameters().getParameter("TZID");
            if (!(dateTime.getTimeZone() == null || parameter != null && parameter.getValue().equals(dateTime.getTimeZone().getID()))) {
                throw new ValidationException("TZID parameter [" + parameter + "] does not match the timezone [" + dateTime.getTimeZone().getID() + "]");
            }
        }
    }
}

