/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.component;

import java.util.Iterator;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.component.Observance;
import net.fortuna.ical4j.util.PropertyValidator;

public class VTimeZone
extends Component {
    private static final long serialVersionUID = 5629679741050917815L;
    private ComponentList observances;

    public VTimeZone(PropertyList propertyList) {
        super("VTIMEZONE", propertyList);
        this.observances = new ComponentList();
    }

    public VTimeZone(ComponentList componentList) {
        super("VTIMEZONE");
        this.observances = componentList;
    }

    public VTimeZone(PropertyList propertyList, ComponentList componentList) {
        super("VTIMEZONE", propertyList);
        this.observances = componentList;
    }

    public final String toString() {
        return "BEGIN:" + this.getName() + "\r\n" + this.getProperties() + this.observances + "END" + ":" + this.getName() + "\r\n";
    }

    public final void validate(boolean bl) throws ValidationException {
        PropertyValidator.getInstance().assertOne("TZID", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("LAST-MODIFIED", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("TZURL", this.getProperties());
        if (this.getObservances().getComponent("STANDARD") == null && this.getObservances().getComponent("DAYLIGHT") == null) {
            throw new ValidationException("Sub-components [STANDARD,DAYLIGHT] must be specified at least once");
        }
        if (bl) {
            this.validateProperties();
        }
    }

    public final ComponentList getObservances() {
        return this.observances;
    }

    public final Observance getApplicableObservance(Date date) {
        Observance observance = null;
        Date date2 = null;
        Iterator iterator = this.getObservances().iterator();
        while (iterator.hasNext()) {
            Observance observance2 = (Observance)iterator.next();
            Date date3 = observance2.getLatestOnset(date);
            if (date2 != null && (date3 == null || !date3.after(date2))) continue;
            date2 = date3;
            observance = observance2;
        }
        return observance;
    }
}

