/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.component;

import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.property.DtStamp;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Status;
import net.fortuna.ical4j.model.property.Summary;
import net.fortuna.ical4j.util.PropertyValidator;

public class VJournal
extends Component {
    private static final long serialVersionUID = -7635140949183238830L;

    public VJournal() {
        super("VJOURNAL");
    }

    public VJournal(PropertyList propertyList) {
        super("VJOURNAL", propertyList);
    }

    public VJournal(Date date, String string) {
        this();
        this.getProperties().add(new DtStamp(new DateTime()));
        this.getProperties().add(new DtStart(date));
        this.getProperties().add(new Summary(string));
    }

    public final void validate(boolean bl) throws ValidationException {
        PropertyValidator.getInstance().assertOneOrLess("CLASS", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("CREATED", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DESCRIPTION", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DTSTART", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DTSTAMP", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("LAST-MODIFIED", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("ORGANIZER", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("RECURRENCE-ID", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("SEQUENCE", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("STATUS", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("SUMMARY", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("UID", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("URL", this.getProperties());
        Status status = (Status)this.getProperties().getProperty("STATUS");
        if (!(status == null || Status.VJOURNAL_DRAFT.equals(status) || Status.VJOURNAL_FINAL.equals(status) || Status.VJOURNAL_CANCELLED.equals(status))) {
            throw new ValidationException("Status property [" + status.toString() + "] may not occur in VJOURNAL");
        }
        if (bl) {
            this.validateProperties();
        }
    }
}

