/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.Serializable;
import java.util.Calendar;
import net.fortuna.ical4j.util.Numbers;

public class WeekDay
implements Serializable {
    private static final long serialVersionUID = -4412000990022011469L;
    public static final WeekDay SU = new WeekDay("SU", 0);
    public static final WeekDay MO = new WeekDay("MO", 0);
    public static final WeekDay TU = new WeekDay("TU", 0);
    public static final WeekDay WE = new WeekDay("WE", 0);
    public static final WeekDay TH = new WeekDay("TH", 0);
    public static final WeekDay FR = new WeekDay("FR", 0);
    public static final WeekDay SA = new WeekDay("SA", 0);
    private String day;
    private int offset;

    public WeekDay(String string) {
        this.offset = string.length() > 2 ? Numbers.parseInt(string.substring(0, string.length() - 2)) : 0;
        this.day = string.substring(string.length() - 2);
    }

    public WeekDay(String string, int n) {
        this.day = string;
        this.offset = n;
    }

    public WeekDay(WeekDay weekDay, int n) {
        this.day = weekDay.getDay();
        this.offset = n;
    }

    public final String getDay() {
        return this.day;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getOffset() != 0) {
            stringBuffer.append(this.getOffset());
        }
        stringBuffer.append(this.getDay());
        return stringBuffer.toString();
    }

    public static final WeekDay getWeekDay(Calendar calendar) {
        return new WeekDay(WeekDay.getDay(calendar.get(7)), 0);
    }

    public static final WeekDay getMonthlyOffset(Calendar calendar) {
        return new WeekDay(WeekDay.getDay(calendar.get(7)), calendar.get(8));
    }

    public static final WeekDay getNegativeMonthlyOffset(Calendar calendar) {
        return new WeekDay(WeekDay.getDay(calendar.get(7)), calendar.get(8) - 6);
    }

    private static WeekDay getDay(int n) {
        switch (n) {
            case 1: {
                return SU;
            }
            case 2: {
                return MO;
            }
            case 3: {
                return TU;
            }
            case 4: {
                return WE;
            }
            case 5: {
                return TH;
            }
            case 6: {
                return FR;
            }
            case 7: {
                return SA;
            }
        }
        return null;
    }

    public static int getCalendarDay(WeekDay weekDay) {
        if (SU.getDay().equals(weekDay.getDay())) {
            return 1;
        }
        if (MO.getDay().equals(weekDay.getDay())) {
            return 2;
        }
        if (TU.getDay().equals(weekDay.getDay())) {
            return 3;
        }
        if (WE.getDay().equals(weekDay.getDay())) {
            return 4;
        }
        if (TH.getDay().equals(weekDay.getDay())) {
            return 5;
        }
        if (FR.getDay().equals(weekDay.getDay())) {
            return 6;
        }
        if (SA.getDay().equals(weekDay.getDay())) {
            return 7;
        }
        return -1;
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof WeekDay)) {
            return false;
        }
        WeekDay weekDay = (WeekDay)object;
        return weekDay.getDay().equals(this.getDay()) && weekDay.getOffset() == this.getOffset();
    }

    public final int hashCode() {
        return this.getDay().hashCode() + this.getOffset();
    }
}

