/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.property.TzId;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimeZoneRegistryImpl
implements TimeZoneRegistry {
    private static final String DEFAULT_RESOURCE_PREFIX = "/zoneinfo/";
    private static Log log = LogFactory.getLog((Class)TimeZoneRegistryImpl.class);
    private Map timezones;
    private String resourcePrefix;

    public TimeZoneRegistryImpl() {
        this(DEFAULT_RESOURCE_PREFIX);
    }

    public TimeZoneRegistryImpl(String string) {
        this.resourcePrefix = string;
        this.timezones = new HashMap();
    }

    public final void register(TimeZone timeZone) {
        this.timezones.put(timeZone.getID(), timeZone);
    }

    public final void clear() {
        this.timezones.clear();
    }

    public final TimeZone getTimeZone(String string) {
        TimeZone timeZone = (TimeZone)this.timezones.get(string);
        if (timeZone == null) {
            try {
                VTimeZone vTimeZone = this.loadVTimeZone(string);
                if (vTimeZone != null) {
                    ((TzId)vTimeZone.getProperties().getProperty("TZID")).setValue(string);
                    timeZone = new TimeZone(vTimeZone);
                    this.register(timeZone);
                }
            }
            catch (Exception exception) {
                log.warn((Object)"Error occurred loading VTimeZone", (Throwable)exception);
            }
        }
        return timeZone;
    }

    private VTimeZone loadVTimeZone(String string) throws IOException, ParserException {
        URL uRL = TimeZoneRegistryImpl.class.getResource(this.resourcePrefix + string + ".ics");
        if (uRL != null) {
            CalendarBuilder calendarBuilder = new CalendarBuilder();
            Calendar calendar = calendarBuilder.build(uRL.openStream());
            return (VTimeZone)calendar.getComponents().getComponent("VTIMEZONE");
        }
        return null;
    }
}

