/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.util.Date;
import java.util.TimeZone;
import net.fortuna.ical4j.model.Iso8601;
import net.fortuna.ical4j.util.TimeZones;

public class Time
extends Iso8601 {
    private static final long serialVersionUID = -8401010870773304348L;
    private static final String DEFAULT_PATTERN = "HHmmss";
    private static final String UTC_PATTERN = "HHmmss'Z'";

    public Time(TimeZone timeZone) {
        super(TimeZones.isUtc(timeZone) ? UTC_PATTERN : DEFAULT_PATTERN, 0);
        this.getFormat().setTimeZone(timeZone);
    }

    public Time(long l, TimeZone timeZone) {
        super(l, TimeZones.isUtc(timeZone) ? UTC_PATTERN : DEFAULT_PATTERN, 0);
        this.getFormat().setTimeZone(timeZone);
    }

    public Time(Date date, TimeZone timeZone) {
        super(date.getTime(), TimeZones.isUtc(timeZone) ? UTC_PATTERN : DEFAULT_PATTERN, 0);
        this.getFormat().setTimeZone(timeZone);
    }

    public final boolean isUtc() {
        return TimeZones.isUtc(this.getFormat().getTimeZone());
    }
}

