/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.model.property.Action;
import net.fortuna.ical4j.model.property.Attach;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Categories;
import net.fortuna.ical4j.model.property.Clazz;
import net.fortuna.ical4j.model.property.Comment;
import net.fortuna.ical4j.model.property.Completed;
import net.fortuna.ical4j.model.property.Contact;
import net.fortuna.ical4j.model.property.Created;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStamp;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Due;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.model.property.ExDate;
import net.fortuna.ical4j.model.property.ExRule;
import net.fortuna.ical4j.model.property.FreeBusy;
import net.fortuna.ical4j.model.property.Geo;
import net.fortuna.ical4j.model.property.LastModified;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.Method;
import net.fortuna.ical4j.model.property.Organizer;
import net.fortuna.ical4j.model.property.PercentComplete;
import net.fortuna.ical4j.model.property.Priority;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.RDate;
import net.fortuna.ical4j.model.property.RRule;
import net.fortuna.ical4j.model.property.RecurrenceId;
import net.fortuna.ical4j.model.property.RelatedTo;
import net.fortuna.ical4j.model.property.Repeat;
import net.fortuna.ical4j.model.property.RequestStatus;
import net.fortuna.ical4j.model.property.Resources;
import net.fortuna.ical4j.model.property.Sequence;
import net.fortuna.ical4j.model.property.Status;
import net.fortuna.ical4j.model.property.Summary;
import net.fortuna.ical4j.model.property.Transp;
import net.fortuna.ical4j.model.property.Trigger;
import net.fortuna.ical4j.model.property.TzId;
import net.fortuna.ical4j.model.property.TzName;
import net.fortuna.ical4j.model.property.TzOffsetFrom;
import net.fortuna.ical4j.model.property.TzOffsetTo;
import net.fortuna.ical4j.model.property.TzUrl;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Url;
import net.fortuna.ical4j.model.property.Version;
import net.fortuna.ical4j.model.property.XProperty;

public final class PropertyFactoryImpl
implements PropertyFactory {
    private static PropertyFactoryImpl instance = new PropertyFactoryImpl();
    private Map factories = new HashMap();

    private PropertyFactoryImpl() {
        this.factories.put("ACTION", this.createActionFactory());
        this.factories.put("ATTACH", this.createAttachFactory());
        this.factories.put("ATTENDEE", this.createAttendeeFactory());
        this.factories.put("CALSCALE", this.createCalScaleFactory());
        this.factories.put("CATEGORIES", this.createCategoriesFactory());
        this.factories.put("CLASS", this.createClazzFactory());
        this.factories.put("COMMENT", this.createCommentFactory());
        this.factories.put("COMPLETED", this.createCompletedFactory());
        this.factories.put("CONTACT", this.createContactFactory());
        this.factories.put("CREATED", this.createCreatedFactory());
        this.factories.put("DESCRIPTION", this.createDescriptionFactory());
        this.factories.put("DTEND", this.createDtEndFactory());
        this.factories.put("DTSTAMP", this.createDtStampFactory());
        this.factories.put("DTSTART", this.createDtStartFactory());
        this.factories.put("DUE", this.createDueFactory());
        this.factories.put("DURATION", this.createDurationFactory());
        this.factories.put("EXDATE", this.createExDateFactory());
        this.factories.put("EXRULE", this.createExRuleFactory());
        this.factories.put("FREEBUSY", this.createFreeBusyFactory());
        this.factories.put("GEO", this.createGeoFactory());
        this.factories.put("LAST-MODIFIED", this.createLastModifiedFactory());
        this.factories.put("LOCATION", this.createLocationFactory());
        this.factories.put("METHOD", this.createMethodFactory());
        this.factories.put("ORGANIZER", this.createOrganizerFactory());
        this.factories.put("PERCENT-COMPLETE", this.createPercentCompleteFactory());
        this.factories.put("PRIORITY", this.createPriorityFactory());
        this.factories.put("PRODID", this.createProdIdFactory());
        this.factories.put("RDATE", this.createRDateFactory());
        this.factories.put("RECURRENCE-ID", this.createRecurrenceIdFactory());
        this.factories.put("RELATED-TO", this.createRelatedToFactory());
        this.factories.put("REPEAT", this.createRepeatFactory());
        this.factories.put("REQUEST-STATUS", this.createRequestStatusFactory());
        this.factories.put("RESOURCES", this.createResourcesFactory());
        this.factories.put("RRULE", this.createRRuleFactory());
        this.factories.put("SEQUENCE", this.createSequenceFactory());
        this.factories.put("STATUS", this.createStatusFactory());
        this.factories.put("SUMMARY", this.createSummaryFactory());
        this.factories.put("TRANSP", this.createTranspFactory());
        this.factories.put("TRIGGER", this.createTriggerFactory());
        this.factories.put("TZID", this.createTzIdFactory());
        this.factories.put("TZNAME", this.createTzNameFactory());
        this.factories.put("TZOFFSETFROM", this.createTzOffsetFromFactory());
        this.factories.put("TZOFFSETTO", this.createTzOffsetToFactory());
        this.factories.put("TZURL", this.createTzUrlFactory());
        this.factories.put("UID", this.createUidFactory());
        this.factories.put("URL", this.createUrlFactory());
        this.factories.put("VERSION", this.createVersionFactory());
    }

    private PropertyFactory createActionFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new Action(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new Action();
            }
        };
    }

    private PropertyFactory createAttachFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new Attach(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new Attach();
            }
        };
    }

    private PropertyFactory createAttendeeFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new Attendee(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new Attendee();
            }
        };
    }

    private PropertyFactory createCalScaleFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new CalScale(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new CalScale();
            }
        };
    }

    private PropertyFactory createCategoriesFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new Categories(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new Categories();
            }
        };
    }

    private PropertyFactory createClazzFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new Clazz(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new Clazz();
            }
        };
    }

    private PropertyFactory createCommentFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new Comment(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new Comment();
            }
        };
    }

    private PropertyFactory createCompletedFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new Completed(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new Completed();
            }
        };
    }

    private PropertyFactory createContactFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new Contact(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new Contact();
            }
        };
    }

    private PropertyFactory createCreatedFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new Created(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new Created();
            }
        };
    }

    private PropertyFactory createDescriptionFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new Description(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new Description();
            }
        };
    }

    private PropertyFactory createDtEndFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new DtEnd(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new DtEnd();
            }
        };
    }

    private PropertyFactory createDtStampFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new DtStamp(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new DtStamp();
            }
        };
    }

    private PropertyFactory createDtStartFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new DtStart(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new DtStart();
            }
        };
    }

    private PropertyFactory createDueFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new Due(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new Due();
            }
        };
    }

    private PropertyFactory createDurationFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new Duration(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new Duration();
            }
        };
    }

    private PropertyFactory createExDateFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new ExDate(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new ExDate();
            }
        };
    }

    private PropertyFactory createExRuleFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new ExRule(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new ExRule();
            }
        };
    }

    private PropertyFactory createFreeBusyFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new FreeBusy(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new FreeBusy();
            }
        };
    }

    private PropertyFactory createGeoFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new Geo(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new Geo();
            }
        };
    }

    private PropertyFactory createLastModifiedFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new LastModified(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new LastModified();
            }
        };
    }

    private PropertyFactory createLocationFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new Location(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new Location();
            }
        };
    }

    private PropertyFactory createMethodFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new Method(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new Method();
            }
        };
    }

    private PropertyFactory createOrganizerFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new Organizer(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new Organizer();
            }
        };
    }

    private PropertyFactory createPercentCompleteFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new PercentComplete(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new PercentComplete();
            }
        };
    }

    private PropertyFactory createPriorityFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new Priority(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new Priority();
            }
        };
    }

    private PropertyFactory createProdIdFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new ProdId(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new ProdId();
            }
        };
    }

    private PropertyFactory createRDateFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new RDate(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new RDate();
            }
        };
    }

    private PropertyFactory createRecurrenceIdFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new RecurrenceId(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new RecurrenceId();
            }
        };
    }

    private PropertyFactory createRelatedToFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new RelatedTo(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new RelatedTo();
            }
        };
    }

    private PropertyFactory createRepeatFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new Repeat(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new Repeat();
            }
        };
    }

    private PropertyFactory createRequestStatusFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new RequestStatus(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new RequestStatus();
            }
        };
    }

    private PropertyFactory createResourcesFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new Resources(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new Resources();
            }
        };
    }

    private PropertyFactory createRRuleFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new RRule(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new RRule();
            }
        };
    }

    private PropertyFactory createSequenceFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new Sequence(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new Sequence();
            }
        };
    }

    private PropertyFactory createStatusFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new Status(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new Status();
            }
        };
    }

    private PropertyFactory createSummaryFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new Summary(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new Summary();
            }
        };
    }

    private PropertyFactory createTranspFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new Transp(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new Transp();
            }
        };
    }

    private PropertyFactory createTriggerFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new Trigger(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new Trigger();
            }
        };
    }

    private PropertyFactory createTzIdFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new TzId(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new TzId();
            }
        };
    }

    private PropertyFactory createTzNameFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new TzName(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new TzName();
            }
        };
    }

    private PropertyFactory createTzOffsetFromFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new TzOffsetFrom(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new TzOffsetFrom();
            }
        };
    }

    private PropertyFactory createTzOffsetToFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new TzOffsetTo(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new TzOffsetTo();
            }
        };
    }

    private PropertyFactory createTzUrlFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new TzUrl(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new TzUrl();
            }
        };
    }

    private PropertyFactory createUidFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new Uid(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new Uid();
            }
        };
    }

    private PropertyFactory createUrlFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new Url(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new Url();
            }
        };
    }

    private PropertyFactory createVersionFactory() {
        return new PropertyFactory(){

            public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
                return new Version(parameterList, string2);
            }

            public Property createProperty(String string) {
                return new Version();
            }
        };
    }

    public static PropertyFactoryImpl getInstance() {
        return instance;
    }

    public Property createProperty(String string) {
        PropertyFactory propertyFactory = (PropertyFactory)this.factories.get(string);
        if (propertyFactory != null) {
            return propertyFactory.createProperty(string);
        }
        if (this.isExperimentalName(string)) {
            return new XProperty(string);
        }
        throw new IllegalArgumentException("Invalid property name: " + string);
    }

    public Property createProperty(String string, ParameterList parameterList, String string2) throws IOException, URISyntaxException, ParseException {
        PropertyFactory propertyFactory = (PropertyFactory)this.factories.get(string);
        if (propertyFactory != null) {
            return propertyFactory.createProperty(string, parameterList, string2);
        }
        if (this.isExperimentalName(string)) {
            return new XProperty(string, parameterList, string2);
        }
        throw new IllegalArgumentException("Invalid property name: " + string);
    }

    private boolean isExperimentalName(String string) {
        return string.startsWith("X-") && string.length() > "X-".length();
    }
}

