/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.Time;
import net.fortuna.ical4j.model.TimeZone;

public class DateTime
extends Date {
    private static final long serialVersionUID = -6407231357919440387L;
    private static final String DEFAULT_PATTERN = "yyyyMMdd'T'HHmmss";
    private static final String UTC_PATTERN = "yyyyMMdd'T'HHmmss'Z'";
    private DateFormat defaultFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss");
    private DateFormat utcFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
    private Time time;
    private TimeZone timezone;

    public DateTime() {
        super(0);
        this.utcFormat.setTimeZone(TimeZone.getTimeZone("Etc/UTC"));
        this.time = new Time(System.currentTimeMillis(), this.getFormat().getTimeZone());
    }

    public DateTime(boolean bl) {
        this();
        this.setUtc(bl);
    }

    public DateTime(long l) {
        super(l, 0);
        this.utcFormat.setTimeZone(TimeZone.getTimeZone("Etc/UTC"));
        this.time = new Time(l, this.getFormat().getTimeZone());
    }

    public DateTime(java.util.Date date) {
        super(date.getTime(), 0);
        this.utcFormat.setTimeZone(TimeZone.getTimeZone("Etc/UTC"));
        this.time = new Time(date.getTime(), this.getFormat().getTimeZone());
        if (date instanceof DateTime) {
            DateTime dateTime = (DateTime)date;
            if (dateTime.isUtc()) {
                this.setUtc(true);
            } else {
                this.setTimeZone(dateTime.getTimeZone());
            }
        }
    }

    public DateTime(String string) throws ParseException {
        this();
        long l = 0L;
        try {
            l = this.utcFormat.parse(string).getTime();
            this.setUtc(true);
        }
        catch (ParseException parseException) {
            this.defaultFormat.setTimeZone(this.getFormat().getTimeZone());
            l = this.defaultFormat.parse(string).getTime();
            this.time = new Time(l, this.getFormat().getTimeZone());
        }
        this.setTime(l);
    }

    public DateTime(String string, TimeZone timeZone) throws ParseException {
        this();
        try {
            this.setTime(this.utcFormat.parse(string).getTime());
            this.setUtc(true);
        }
        catch (ParseException parseException) {
            if (timeZone != null) {
                this.defaultFormat.setTimeZone(timeZone);
            } else {
                this.defaultFormat.setTimeZone(this.getFormat().getTimeZone());
            }
            this.setTime(this.defaultFormat.parse(string).getTime());
            this.setTimeZone(timeZone);
        }
    }

    public final void setTime(long l) {
        super.setTime(l);
        this.time.setTime(l);
    }

    public final boolean isUtc() {
        return this.time.isUtc();
    }

    public final void setUtc(boolean bl) {
        this.setTimeZone(null);
        if (bl) {
            this.getFormat().setTimeZone(TimeZone.getTimeZone("Etc/UTC"));
            this.time = new Time(this.time, this.getFormat().getTimeZone());
        }
    }

    public final void setTimeZone(TimeZone timeZone) {
        this.timezone = timeZone;
        if (timeZone != null) {
            this.getFormat().setTimeZone(timeZone);
        } else {
            this.getFormat().setTimeZone(TimeZone.getTimeZone("Etc/GMT"));
        }
        this.time = new Time(this.time, this.getFormat().getTimeZone());
    }

    public final TimeZone getTimeZone() {
        return this.timezone;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append('T');
        stringBuffer.append(this.time.toString());
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof DateTime) {
            return this.time.equals(((DateTime)object).time) && super.equals(object);
        }
        return super.equals(object);
    }

    public int hashCode() {
        return this.time.hashCode() + super.hashCode();
    }
}

