/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.Serializable;
import java.util.Iterator;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.ValidationException;

public abstract class Component
implements Serializable {
    public static final String BEGIN = "BEGIN";
    public static final String END = "END";
    public static final String VEVENT = "VEVENT";
    public static final String VTODO = "VTODO";
    public static final String VJOURNAL = "VJOURNAL";
    public static final String VFREEBUSY = "VFREEBUSY";
    public static final String VTIMEZONE = "VTIMEZONE";
    public static final String VALARM = "VALARM";
    public static final String EXPERIMENTAL_PREFIX = "X-";
    private String name;
    private PropertyList properties;

    protected Component(String string) {
        this(string, new PropertyList());
    }

    protected Component(String string, PropertyList propertyList) {
        this.name = string;
        this.properties = propertyList;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(BEGIN);
        stringBuffer.append(':');
        stringBuffer.append(this.getName());
        stringBuffer.append("\r\n");
        stringBuffer.append(this.getProperties());
        stringBuffer.append(END);
        stringBuffer.append(':');
        stringBuffer.append(this.getName());
        stringBuffer.append("\r\n");
        return stringBuffer.toString();
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isCalendarComponent() {
        return VALARM.equals(this.getName()) || VEVENT.equals(this.getName()) || VFREEBUSY.equals(this.getName()) || VJOURNAL.equals(this.getName()) || VTIMEZONE.equals(this.getName()) || VTODO.equals(this.getName());
    }

    public final PropertyList getProperties() {
        return this.properties;
    }

    public final void validate() throws ValidationException {
        this.validate(true);
    }

    public abstract void validate(boolean var1) throws ValidationException;

    protected final void validateProperties() throws ValidationException {
        Iterator iterator = this.getProperties().iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            property.validate();
        }
    }

    public final boolean equals(Object object) {
        if (object instanceof Component) {
            Component component = (Component)object;
            return this.getName().equals(component.getName()) && this.getProperties().equals(component.getProperties());
        }
        return super.equals(object);
    }

    public final int hashCode() {
        return this.getName().hashCode() + this.getProperties().hashCode();
    }
}

