/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.Serializable;
import java.util.Iterator;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.property.XProperty;
import net.fortuna.ical4j.util.PropertyValidator;

public class Calendar
implements Serializable {
    private static final long serialVersionUID = -1654118204678581940L;
    public static final String BEGIN = "BEGIN";
    public static final String VCALENDAR = "VCALENDAR";
    public static final String END = "END";
    private PropertyList properties;
    private ComponentList components;

    public Calendar() {
        this(new PropertyList(), new ComponentList());
    }

    public Calendar(ComponentList componentList) {
        this(new PropertyList(), componentList);
    }

    public Calendar(PropertyList propertyList, ComponentList componentList) {
        this.properties = propertyList;
        this.components = componentList;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(BEGIN);
        stringBuffer.append(':');
        stringBuffer.append(VCALENDAR);
        stringBuffer.append("\r\n");
        stringBuffer.append(this.getProperties());
        stringBuffer.append(this.getComponents());
        stringBuffer.append(END);
        stringBuffer.append(':');
        stringBuffer.append(VCALENDAR);
        stringBuffer.append("\r\n");
        return stringBuffer.toString();
    }

    public final ComponentList getComponents() {
        return this.components;
    }

    public final PropertyList getProperties() {
        return this.properties;
    }

    public final void validate() throws ValidationException {
        this.validate(true);
    }

    public final void validate(boolean bl) throws ValidationException {
        Serializable serializable;
        PropertyValidator.getInstance().assertOne("PRODID", this.properties);
        PropertyValidator.getInstance().assertOne("VERSION", this.properties);
        PropertyValidator.getInstance().assertOneOrLess("CALSCALE", this.properties);
        PropertyValidator.getInstance().assertOneOrLess("METHOD", this.properties);
        if (this.getComponents().isEmpty()) {
            throw new ValidationException("Calendar must contain at least one component");
        }
        Iterator iterator = this.getProperties().iterator();
        while (iterator.hasNext()) {
            serializable = (Property)iterator.next();
            if (serializable instanceof XProperty || ((Property)serializable).isCalendarProperty()) continue;
            throw new IllegalArgumentException("Invalid property: " + ((Property)serializable).getName());
        }
        iterator = this.getComponents().iterator();
        while (iterator.hasNext()) {
            serializable = (Component)iterator.next();
            if (((Component)serializable).isCalendarComponent()) continue;
            throw new IllegalArgumentException("Invalid component: " + ((Component)serializable).getName());
        }
        if (bl) {
            this.validateProperties();
            this.validateComponents();
        }
    }

    private void validateProperties() throws ValidationException {
        Iterator iterator = this.getProperties().iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            property.validate();
        }
    }

    private void validateComponents() throws ValidationException {
        Iterator iterator = this.getComponents().iterator();
        while (iterator.hasNext()) {
            Component component = (Component)iterator.next();
            component.validate();
        }
    }

    public final boolean equals(Object object) {
        if (object instanceof Calendar) {
            Calendar calendar = (Calendar)object;
            return this.getProperties().equals(calendar.getProperties()) && this.getComponents().equals(calendar.getComponents());
        }
        return super.equals(object);
    }

    public final int hashCode() {
        return this.getProperties().hashCode() + this.getComponents().hashCode();
    }
}

