/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.data;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UnfoldingReader
extends PushbackReader {
    private static Log log = LogFactory.getLog((Class)UnfoldingReader.class);
    private static final char[] DEFAULT_FOLD_PATTERN = new char[]{'\r', '\n', ' '};
    private static final char[] RELAXED_FOLD_PATTERN = new char[]{'\n', ' '};
    private static final List FOLD_PATTERNS = new ArrayList();
    private List buffers = new ArrayList();
    private int linesUnfolded;

    public UnfoldingReader(Reader reader) {
        super(reader, DEFAULT_FOLD_PATTERN.length);
        Iterator iterator = FOLD_PATTERNS.iterator();
        while (iterator.hasNext()) {
            char[] cArray = (char[])iterator.next();
            this.buffers.add(new char[cArray.length]);
        }
    }

    public final int getLinesUnfolded() {
        return this.linesUnfolded;
    }

    public final int read() throws IOException {
        boolean bl;
        do {
            bl = false;
            for (int i = 0; i < this.buffers.size(); ++i) {
                char[] cArray = (char[])this.buffers.get(i);
                int n = super.read(cArray);
                if (n > 0) {
                    if (!Arrays.equals((char[])FOLD_PATTERNS.get(i), cArray)) {
                        this.unread(cArray, 0, n);
                        continue;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Unfolding...");
                    }
                    ++this.linesUnfolded;
                    bl = true;
                    continue;
                }
                return n;
            }
        } while (bl);
        return super.read();
    }

    static {
        FOLD_PATTERNS.add(DEFAULT_FOLD_PATTERN);
        if ("true".equals(System.getProperty("ical4j.unfolding.relaxed"))) {
            FOLD_PATTERNS.add(RELAXED_FOLD_PATTERN);
        }
    }
}

