/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.data;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import net.fortuna.ical4j.data.FoldingWriter;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.ValidationException;

public class CalendarOutputter {
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private boolean validating;
    private int foldLength;

    public CalendarOutputter() {
        this(true);
    }

    public CalendarOutputter(boolean bl) {
        this(bl, 73);
    }

    public CalendarOutputter(boolean bl, int n) {
        this.validating = bl;
        this.foldLength = n;
    }

    public final void output(Calendar calendar, OutputStream outputStream) throws IOException, ValidationException {
        this.output(calendar, new OutputStreamWriter(outputStream, DEFAULT_CHARSET));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void output(Calendar calendar, Writer writer) throws IOException, ValidationException {
        if (this.isValidating()) {
            calendar.validate();
        }
        FoldingWriter foldingWriter = new FoldingWriter(writer, this.foldLength);
        try {
            foldingWriter.write(calendar.toString());
        }
        finally {
            foldingWriter.close();
        }
    }

    public final boolean isValidating() {
        return this.validating;
    }

    public final void setValidating(boolean bl) {
        this.validating = bl;
    }
}

