/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.JavaParser;
import net.sourceforge.pmd.ast.ParseException;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.jaxen.DocumentNavigator;
import org.jaxen.BaseXPath;
import org.jaxen.JaxenException;
import org.jaxen.Navigator;

public class ASTViewer {
    private static final String SETTINGS_FILE_NAME = System.getProperty("user.home") + System.getProperty("file.separator") + ".pmd_astviewer";
    private JTextPane codeEditorPane = new JTextPane();
    private JTextArea astArea = new JTextArea();
    private JTextArea xpathResultArea = new JTextArea();
    private JTextArea xpathQueryArea = new JTextArea(8, 40);
    private JFrame frame = new JFrame("AST Viewer");

    public ASTViewer() {
        JSmartPanel codePanel = new JSmartPanel();
        JScrollPane codeScrollPane = new JScrollPane(this.codeEditorPane);
        codePanel.add(codeScrollPane, 0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0));
        JSmartPanel astPanel = new JSmartPanel();
        this.astArea.setRows(20);
        this.astArea.setColumns(20);
        JScrollPane astScrollPane = new JScrollPane(this.astArea);
        astPanel.add(astScrollPane, 0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0));
        JSmartPanel xpathResultPanel = new JSmartPanel();
        this.xpathResultArea.setRows(20);
        this.xpathResultArea.setColumns(20);
        JScrollPane xpathResultScrollPane = new JScrollPane(this.xpathResultArea);
        xpathResultPanel.add(xpathResultScrollPane, 0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0));
        JButton goButton = new JButton("Go");
        goButton.setMnemonic('g');
        goButton.addActionListener(new ShowListener());
        goButton.addActionListener(new SaveListener());
        goButton.addActionListener(new XPathListener());
        JPanel controlPanel = new JPanel();
        controlPanel.add(new JLabel("XPath Query (if any) ->"));
        this.xpathQueryArea.setBorder(BorderFactory.createLineBorder(Color.black));
        controlPanel.add(new JScrollPane(this.xpathQueryArea));
        controlPanel.add(goButton);
        JSplitPane resultsSplitPane = new JSplitPane(1, astPanel, xpathResultPanel);
        JSplitPane upperSplitPane = new JSplitPane(1, codePanel, resultsSplitPane);
        JSplitPane containerSplitPane = new JSplitPane(0, upperSplitPane, controlPanel);
        this.frame.getContentPane().add(containerSplitPane);
        this.frame.setSize(1000, 500);
        this.frame.setDefaultCloseOperation(3);
        int screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        int screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        this.frame.setLocation(screenWidth / 2 - this.frame.getWidth() / 2, screenHeight / 2 - this.frame.getHeight() / 2);
        this.frame.setVisible(true);
        this.frame.show();
        containerSplitPane.setDividerLocation(containerSplitPane.getMaximumDividerLocation() - containerSplitPane.getMaximumDividerLocation() / 4);
        upperSplitPane.setDividerLocation(upperSplitPane.getMaximumDividerLocation() / 3);
        this.codeEditorPane.setText(this.loadText());
        this.codeEditorPane.setSize(upperSplitPane.getMaximumDividerLocation() / 3, containerSplitPane.getMaximumDividerLocation() - containerSplitPane.getMaximumDividerLocation() / 4);
    }

    private String loadText() {
        try {
            BufferedReader br = new BufferedReader(new FileReader(new File(SETTINGS_FILE_NAME)));
            StringBuffer text = new StringBuffer();
            String hold = null;
            while ((hold = br.readLine()) != null) {
                text.append(hold);
                text.append(System.getProperty("line.separator"));
            }
            return text.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static void main(String[] args) {
        new ASTViewer();
    }

    private class XPathListener
    implements ActionListener {
        private XPathListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            if (ASTViewer.this.xpathQueryArea.getText().length() == 0) {
                ASTViewer.this.xpathResultArea.setText("XPath query field is empty");
                ASTViewer.this.codeEditorPane.requestFocus();
                return;
            }
            StringReader sr = new StringReader(ASTViewer.this.codeEditorPane.getText());
            JavaParser parser = new JavaParser(sr);
            try {
                BaseXPath xpath = new BaseXPath(ASTViewer.this.xpathQueryArea.getText(), (Navigator)new DocumentNavigator());
                ASTCompilationUnit c = parser.CompilationUnit();
                StringBuffer sb = new StringBuffer();
                Iterator iter = xpath.selectNodes((Object)c).iterator();
                while (iter.hasNext()) {
                    SimpleNode node = (SimpleNode)iter.next();
                    String name = node.getClass().getName().substring(node.getClass().getName().lastIndexOf(46) + 1);
                    String line = " at line " + String.valueOf(node.getBeginLine());
                    sb.append(name).append(line).append(System.getProperty("line.separator"));
                }
                ASTViewer.this.xpathResultArea.setText(sb.toString());
                if (sb.length() == 0) {
                    ASTViewer.this.xpathResultArea.setText("No results returned " + System.currentTimeMillis());
                }
            }
            catch (ParseException pe) {
                ASTViewer.this.xpathResultArea.setText(pe.fillInStackTrace().getMessage());
            }
            catch (JaxenException je) {
                ASTViewer.this.xpathResultArea.setText(je.fillInStackTrace().getMessage());
            }
            ASTViewer.this.xpathQueryArea.requestFocus();
        }
    }

    private class SaveListener
    implements ActionListener {
        private SaveListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            try {
                File f = new File(SETTINGS_FILE_NAME);
                FileWriter fw = new FileWriter(f);
                fw.write(ASTViewer.this.codeEditorPane.getText());
                fw.close();
            }
            catch (IOException ioe) {}
        }
    }

    private class ShowListener
    implements ActionListener {
        private ShowListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            StringReader sr = new StringReader(ASTViewer.this.codeEditorPane.getText());
            JavaParser parser = new JavaParser(sr);
            MyPrintStream ps = new MyPrintStream();
            System.setOut(ps);
            try {
                ASTCompilationUnit c = parser.CompilationUnit();
                c.dump("");
                ASTViewer.this.astArea.setText(ps.getString());
            }
            catch (ParseException pe) {
                ASTViewer.this.astArea.setText(pe.fillInStackTrace().getMessage());
            }
        }
    }

    private static class MyPrintStream
    extends PrintStream {
        private StringBuffer buf = new StringBuffer();

        public MyPrintStream() {
            super(System.out);
        }

        public void println(String s) {
            super.println(s);
            this.buf.append(s);
            this.buf.append(System.getProperty("line.separator"));
        }

        public String getString() {
            return this.buf.toString();
        }
    }

    private static class JSmartPanel
    extends JPanel {
        private GridBagConstraints constraints = new GridBagConstraints();

        public JSmartPanel() {
            super(new GridBagLayout());
        }

        public void add(Component comp, int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int anchor, int fill, Insets insets) {
            this.constraints.gridx = gridx;
            this.constraints.gridy = gridy;
            this.constraints.gridwidth = gridwidth;
            this.constraints.gridheight = gridheight;
            this.constraints.weightx = weightx;
            this.constraints.weighty = weighty;
            this.constraints.anchor = anchor;
            this.constraints.fill = fill;
            this.constraints.insets = insets;
            this.add(comp, this.constraints);
        }
    }
}

