/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.symboltable;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.symboltable.NameOccurrence;

public class NameOccurrences {
    private List names = new ArrayList();

    public NameOccurrences(ASTPrimaryExpression node) {
        this.buildOccurrences(node);
    }

    public List getNames() {
        return this.names;
    }

    public Iterator iterator() {
        return this.names.iterator();
    }

    private void buildOccurrences(ASTPrimaryExpression node) {
        ASTPrimaryPrefix prefix = (ASTPrimaryPrefix)node.jjtGetChild(0);
        if (prefix.usesSuperModifier()) {
            this.add(new NameOccurrence(prefix, "super"));
        } else if (prefix.usesThisModifier()) {
            this.add(new NameOccurrence(prefix, "this"));
        }
        this.checkForNameChild(prefix);
        int i = 1;
        while (i < node.jjtGetNumChildren()) {
            this.checkForNameChild((ASTPrimarySuffix)node.jjtGetChild(i));
            ++i;
        }
    }

    private void checkForNameChild(SimpleNode node) {
        if (node.getImage() != null) {
            this.add(new NameOccurrence(node, node.getImage()));
        }
        if (node.jjtGetNumChildren() > 0 && node.jjtGetChild(0) instanceof ASTName) {
            ASTName grandchild = (ASTName)node.jjtGetChild(0);
            StringTokenizer st = new StringTokenizer(grandchild.getImage(), ".");
            while (st.hasMoreTokens()) {
                this.add(new NameOccurrence(grandchild, st.nextToken()));
            }
        }
        if (node instanceof ASTPrimarySuffix && ((ASTPrimarySuffix)node).isArguments()) {
            ((NameOccurrence)this.names.get(this.names.size() - 1)).setIsMethodOrConstructorInvocation();
        }
    }

    private void add(NameOccurrence name) {
        this.names.add(name);
        if (this.names.size() > 1) {
            NameOccurrence qualifiedName = (NameOccurrence)this.names.get(this.names.size() - 2);
            qualifiedName.setNameWhichThisQualifies(name);
        }
    }

    public String toString() {
        String result = "";
        Iterator i = this.names.iterator();
        while (i.hasNext()) {
            NameOccurrence occ = (NameOccurrence)i.next();
            result = result + occ.getImage();
        }
        return result;
    }
}

