/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.ast.ASTArgumentList;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTLiteral;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleNode;

public class AvoidDuplicateLiteralsRule
extends AbstractRule {
    private static final char DEFAULT_SEPARATOR = ',';
    private static final String EXCEPTION_LIST_PROPERTY = "exceptionlist";
    private static final String SEPARATOR_PROPERTY = "separator";
    private static final String EXCEPTION_FILE_NAME_PROPERTY = "exceptionfile";
    private Map literals = new HashMap();
    private Set exceptions = new HashSet();

    public Object visit(ASTCompilationUnit node, Object data) {
        this.literals.clear();
        if (this.hasProperty(EXCEPTION_LIST_PROPERTY)) {
            ExceptionParser p = this.hasProperty(SEPARATOR_PROPERTY) ? new ExceptionParser(this.getStringProperty(SEPARATOR_PROPERTY).charAt(0)) : new ExceptionParser(',');
            this.exceptions = p.parse(this.getStringProperty(EXCEPTION_LIST_PROPERTY));
        } else if (this.hasProperty(EXCEPTION_FILE_NAME_PROPERTY)) {
            this.exceptions = new HashSet();
            try {
                LineNumberReader reader = new LineNumberReader(new BufferedReader(new FileReader(new File(this.getStringProperty(EXCEPTION_FILE_NAME_PROPERTY)))));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    this.exceptions.add(line);
                }
                reader.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        super.visit(node, data);
        int threshold = this.getIntProperty("threshold");
        Iterator i = this.literals.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            List occurrences = (List)this.literals.get(key);
            if (occurrences.size() < threshold) continue;
            Object[] args = new Object[]{new Integer(occurrences.size()), new Integer(((SimpleNode)occurrences.get(0)).getBeginLine())};
            String msg = MessageFormat.format(this.getMessage(), args);
            RuleContext ctx = (RuleContext)data;
            ctx.getReport().addRuleViolation(this.createRuleViolation(ctx, ((SimpleNode)occurrences.get(0)).getBeginLine(), msg));
        }
        return data;
    }

    public Object visit(ASTLiteral node, Object data) {
        if (!this.hasAtLeastSixParents(node)) {
            return data;
        }
        if (!(node.jjtGetParent().jjtGetParent().jjtGetParent().jjtGetParent().jjtGetParent().jjtGetParent() instanceof ASTArgumentList)) {
            return data;
        }
        if (node.getImage() == null || node.getImage().indexOf(34) == -1 || node.getImage().length() < 3) {
            return data;
        }
        if (this.exceptions.contains(node.getImage().substring(1, node.getImage().length() - 1))) {
            return data;
        }
        if (this.literals.containsKey(node.getImage())) {
            List occurrences = (List)this.literals.get(node.getImage());
            occurrences.add(node);
        } else {
            ArrayList<ASTLiteral> occurrences = new ArrayList<ASTLiteral>();
            occurrences.add(node);
            this.literals.put(node.getImage(), occurrences);
        }
        return data;
    }

    private boolean hasAtLeastSixParents(Node node) {
        Node currentNode = node;
        int i = 0;
        while (i < 6) {
            if (currentNode instanceof ASTCompilationUnit) {
                return false;
            }
            currentNode = currentNode.jjtGetParent();
            ++i;
        }
        return true;
    }

    public static class ExceptionParser {
        private static final char ESCAPE_CHAR = '\\';
        private char delimiter;

        public ExceptionParser(char delimiter) {
            this.delimiter = delimiter;
        }

        public Set parse(String in) {
            HashSet<String> result = new HashSet<String>();
            StringBuffer currentToken = new StringBuffer();
            boolean inEscapeMode = false;
            int i = 0;
            while (i < in.length()) {
                if (inEscapeMode) {
                    inEscapeMode = false;
                    currentToken.append(in.charAt(i));
                } else if (!inEscapeMode && in.charAt(i) == '\\') {
                    inEscapeMode = true;
                } else if (in.charAt(i) == this.delimiter) {
                    result.add(currentToken.toString());
                    currentToken = new StringBuffer();
                } else {
                    currentToken.append(in.charAt(i));
                }
                ++i;
            }
            if (currentToken.length() > 0) {
                result.add(currentToken.toString());
                currentToken = new StringBuffer();
            }
            return result;
        }
    }
}

