/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.util.Iterator;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.util.StringUtil;

public class CSVRenderer
implements Renderer {
    public String render(Report report) {
        StringBuffer buf = new StringBuffer(this.quoteAndCommify("Problem"));
        buf.append(this.quoteAndCommify("File"));
        buf.append(this.quoteAndCommify("Line"));
        buf.append(this.quote("Description"));
        buf.append(PMD.EOL);
        int violationCount = 1;
        Iterator i = report.iterator();
        while (i.hasNext()) {
            RuleViolation rv = (RuleViolation)i.next();
            buf.append(this.quoteAndCommify(Integer.toString(violationCount)));
            buf.append(this.quoteAndCommify(rv.getFilename()));
            buf.append(this.quoteAndCommify(Integer.toString(rv.getLine())));
            buf.append(this.quote(StringUtil.replaceString(rv.getDescription(), '\"', "'")));
            buf.append(PMD.EOL);
            ++violationCount;
        }
        return buf.toString();
    }

    private String quote(String d) {
        return "\"" + d + "\"";
    }

    private String quoteAndCommify(String d) {
        return this.quote(d) + ",";
    }
}

