/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sourceforge.pmd.cpd.CPDListener;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.MarkComparator;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.MatchCollector;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokens;

public class MatchAlgorithm {
    private Map pool = new TreeMap();
    private List code = new ArrayList();
    private List marks = new ArrayList();
    private List matches;
    private Map source;
    private Tokens tokens;
    private CPDListener cpdListener;

    public MatchAlgorithm(Map sourceCode, Tokens tokens) {
        this.source = sourceCode;
        this.tokens = tokens;
        Iterator i = tokens.iterator();
        while (i.hasNext()) {
            this.add((TokenEntry)i.next());
        }
    }

    public void setListener(CPDListener listener) {
        this.cpdListener = listener;
    }

    public void add(TokenEntry token) {
        if (!this.pool.containsKey(token)) {
            this.pool.put(token, token);
        }
        this.code.add(this.pool.get(token));
        if (!token.equals(TokenEntry.EOF)) {
            this.marks.add(new Mark(this.code.size(), token.getTokenSrcID(), token.getIndex(), token.getBeginLine()));
        }
    }

    public void findMatches(int min) {
        int count = 1;
        Iterator iter = this.pool.keySet().iterator();
        while (iter.hasNext()) {
            TokenEntry token = (TokenEntry)iter.next();
            token.setSortCode(count++);
        }
        MarkComparator mc = new MarkComparator(this.cpdListener, this.code);
        Collections.sort(this.marks, mc);
        MatchCollector coll = new MatchCollector(this.marks, mc);
        this.matches = coll.collect(min);
        Collections.sort(this.matches);
        Iterator i = this.matches();
        while (i.hasNext()) {
            Match match = (Match)i.next();
            Iterator occurrences = match.iterator();
            while (occurrences.hasNext()) {
                Mark mark = (Mark)occurrences.next();
                match.setLineCount(this.tokens.getLineCount(mark, match));
                if (occurrences.hasNext()) continue;
                int start = mark.getBeginLine();
                int end = start + match.getLineCount() - 1;
                SourceCode sourceCode = (SourceCode)this.source.get(mark.getTokenSrcID());
                match.setSourceCodeSlice(sourceCode.getSlice(start, end));
            }
        }
    }

    public Iterator matches() {
        return this.matches.iterator();
    }
}

