/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.ast;

import net.sourceforge.pmd.ast.AccessFlags;
import net.sourceforge.pmd.ast.JavaParser;
import net.sourceforge.pmd.ast.SimpleNode;

public class AccessNode
extends SimpleNode
implements AccessFlags {
    protected short accessFlags = 0;

    public AccessNode(int i) {
        super(i);
    }

    public AccessNode(JavaParser parser, int i) {
        super(parser, i);
    }

    public void setPublic() {
        this.accessFlags = (short)(this.accessFlags | 1);
    }

    public boolean isPublic() {
        return (this.accessFlags & 1) > 0;
    }

    public void setPrivate() {
        this.accessFlags = (short)(this.accessFlags | 2);
    }

    public boolean isPrivate() {
        return (this.accessFlags & 2) > 0;
    }

    public void setProtected() {
        this.accessFlags = (short)(this.accessFlags | 4);
    }

    public boolean isProtected() {
        return (this.accessFlags & 4) > 0;
    }

    public void setStatic() {
        this.accessFlags = (short)(this.accessFlags | 8);
    }

    public boolean isStatic() {
        return (this.accessFlags & 8) > 0;
    }

    public void setFinal() {
        this.accessFlags = (short)(this.accessFlags | 0x10);
    }

    public boolean isFinal() {
        return (this.accessFlags & 0x10) > 0;
    }

    public void setSynchronized() {
        this.accessFlags = (short)(this.accessFlags | 0x20);
    }

    public boolean isSynchronized() {
        return (this.accessFlags & 0x20) > 0;
    }

    public void setVolatile() {
        this.accessFlags = (short)(this.accessFlags | 0x40);
    }

    public boolean isVolatile() {
        return (this.accessFlags & 0x40) > 0;
    }

    public void setTransient() {
        this.accessFlags = (short)(this.accessFlags | 0x80);
    }

    public boolean isTransient() {
        return (this.accessFlags & 0x80) > 0;
    }

    public void setNative() {
        this.accessFlags = (short)(this.accessFlags | 0x100);
    }

    public boolean isNative() {
        return (this.accessFlags & 0x100) > 0;
    }

    public void setInterface() {
        this.accessFlags = (short)(this.accessFlags | 0x200);
    }

    public boolean isInterface() {
        return (this.accessFlags & 0x200) > 0;
    }

    public void setAbstract() {
        this.accessFlags = (short)(this.accessFlags | 0x400);
    }

    public boolean isAbstract() {
        return (this.accessFlags & 0x400) > 0;
    }

    public void setStrict() {
        this.accessFlags = (short)(this.accessFlags | 0x800);
    }

    public boolean isStrict() {
        return (this.accessFlags & 0x800) > 0;
    }

    public void setSuper() {
        this.accessFlags = (short)(this.accessFlags | 0x20);
    }

    public boolean isSuper() {
        return (this.accessFlags & 0x20) > 0;
    }

    public String collectDumpedModifiers(String prefix) {
        String out = this.toString(prefix) + ":";
        if (this.isPrivate()) {
            out = out + "(private)";
        }
        if (this.isPublic()) {
            out = out + "(public)";
        }
        if (this.isAbstract()) {
            out = out + "(abstract)";
        }
        if (this.isStatic()) {
            out = out + "(static)";
        }
        if (this.isFinal()) {
            out = out + "(final)";
        }
        if (this.isSynchronized()) {
            out = out + "(synchronized)";
        }
        if (this.isNative()) {
            out = out + "(native)";
        }
        if (this.isStrict()) {
            out = out + "(strict)";
        }
        if (this.isTransient()) {
            out = out + "(transient)";
        }
        return out;
    }
}

