/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.TargetJDK1_3;
import net.sourceforge.pmd.ant.Formatter;
import net.sourceforge.pmd.renderers.TextRenderer;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class PMDTask
extends Task {
    private Path classpath;
    private List formatters = new ArrayList();
    private List filesets = new ArrayList();
    private boolean shortFilenames;
    private boolean printToConsole;
    private String ruleSetFiles;
    private boolean failOnError;
    private boolean failOnRuleViolation;
    private boolean targetJDK13;
    protected String EOL = System.getProperty("line.separator", "\n");

    public void setShortFilenames(boolean value) {
        this.shortFilenames = value;
    }

    public void setTargetJDK13(boolean value) {
        this.targetJDK13 = value;
    }

    public void setFailOnError(boolean fail) {
        this.failOnError = fail;
    }

    public void setFailOnRuleViolation(boolean fail) {
        this.failOnRuleViolation = fail;
    }

    public void setPrintToConsole(boolean printToConsole) {
        this.printToConsole = printToConsole;
    }

    public void setRuleSetFiles(String ruleSetFiles) {
        this.ruleSetFiles = ruleSetFiles;
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void addFormatter(Formatter f) {
        this.formatters.add(f);
    }

    public void setClasspath(Path classpath) {
        this.classpath = classpath;
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createLongClasspath().setRefid(r);
    }

    public void execute() throws BuildException {
        RuleSet rules;
        this.validate();
        try {
            RuleSetFactory ruleSetFactory = new RuleSetFactory();
            if (this.classpath == null) {
                this.log("Using the normal ClassLoader", 3);
                rules = ruleSetFactory.createRuleSet(this.ruleSetFiles);
            } else {
                this.log("Using the AntClassLoader", 3);
                rules = ruleSetFactory.createRuleSet(this.ruleSetFiles, (ClassLoader)new AntClassLoader(this.project, this.classpath));
            }
        }
        catch (RuleSetNotFoundException e) {
            throw new BuildException(e.getMessage());
        }
        this.logRulesUsed(rules);
        PMD pmd = this.targetJDK13 ? new PMD(new TargetJDK1_3()) : new PMD();
        RuleContext ctx = new RuleContext();
        ctx.setReport(new Report());
        Iterator i = this.filesets.iterator();
        while (i.hasNext()) {
            FileSet fs = (FileSet)i.next();
            DirectoryScanner ds = fs.getDirectoryScanner(this.project);
            String[] srcFiles = ds.getIncludedFiles();
            int j = 0;
            while (j < srcFiles.length) {
                File file = new File(ds.getBasedir() + System.getProperty("file.separator") + srcFiles[j]);
                this.log("Processing file " + file.getAbsoluteFile().toString(), 3);
                ctx.setSourceCodeFilename(this.shortFilenames ? srcFiles[j] : file.getAbsolutePath());
                try {
                    pmd.processFile(new FileInputStream(file), rules, ctx);
                }
                catch (FileNotFoundException fnfe) {
                    if (this.failOnError) {
                        throw new BuildException((Throwable)fnfe);
                    }
                }
                catch (PMDException pmde) {
                    this.log(pmde.toString(), 3);
                    if (pmde.getReason() != null && pmde.getReason().getMessage() != null) {
                        this.log(pmde.getReason().getMessage(), 3);
                    }
                    if (this.failOnError) {
                        throw new BuildException((Throwable)pmde);
                    }
                    ctx.getReport().addError(new Report.ProcessingError(pmde.getMessage(), ctx.getSourceCodeFilename()));
                }
                ++j;
            }
        }
        this.log(ctx.getReport().size() + " problems found", 3);
        if (!ctx.getReport().isEmpty()) {
            Iterator i2 = this.formatters.iterator();
            while (i2.hasNext()) {
                Formatter formatter = (Formatter)i2.next();
                this.log("Sending a report to " + formatter, 3);
                String buffer = formatter.getRenderer().render(ctx.getReport()) + this.EOL;
                try {
                    Writer writer = formatter.getToFileWriter(this.project.getBaseDir().toString());
                    writer.write(buffer, 0, buffer.length());
                    writer.close();
                }
                catch (IOException ioe) {
                    throw new BuildException(ioe.getMessage());
                }
            }
            if (this.printToConsole) {
                TextRenderer r = new TextRenderer();
                this.log(r.render(ctx.getReport()), 2);
            }
            if (this.failOnRuleViolation) {
                throw new BuildException("Stopping build since PMD found " + ctx.getReport().size() + " rule violations in the code");
            }
        }
    }

    private void logRulesUsed(RuleSet rules) {
        this.log("Using these rulesets: " + this.ruleSetFiles, 3);
        Iterator i = rules.getRules().iterator();
        while (i.hasNext()) {
            Rule rule = (Rule)i.next();
            this.log("Using rule " + rule.getName(), 3);
        }
    }

    private void validate() throws BuildException {
        if (this.formatters.isEmpty() && !this.printToConsole) {
            throw new BuildException("No formatter specified; and printToConsole was false");
        }
        Iterator i = this.formatters.iterator();
        while (i.hasNext()) {
            Formatter f = (Formatter)i.next();
            if (!f.isToFileNull()) continue;
            throw new BuildException("Formatter toFile attribute is required");
        }
        if (this.ruleSetFiles == null) {
            throw new BuildException("No rulesets specified");
        }
    }

    private Path createLongClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.project);
        }
        return this.classpath.createPath();
    }
}

