/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.ant;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import net.sourceforge.pmd.renderers.CSVRenderer;
import net.sourceforge.pmd.renderers.HTMLRenderer;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.renderers.TextRenderer;
import net.sourceforge.pmd.renderers.XMLRenderer;
import org.apache.tools.ant.BuildException;

public class Formatter {
    private Renderer renderer;
    private File toFile;

    public void setType(String type) {
        if (type.equals("xml")) {
            this.renderer = new XMLRenderer();
        } else if (type.equals("html")) {
            this.renderer = new HTMLRenderer();
        } else if (type.equals("csv")) {
            this.renderer = new CSVRenderer();
        } else if (type.equals("text")) {
            this.renderer = new TextRenderer();
        } else if (!type.equals("")) {
            try {
                this.renderer = (Renderer)Class.forName(type).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BuildException("Unable to instantiate custom formatter: " + type);
            }
        } else {
            throw new BuildException("Formatter type must be 'xml', 'text', 'html', 'csv', or a class name; you specified " + type);
        }
    }

    public void setToFile(File toFile) {
        this.toFile = toFile;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public boolean isToFileNull() {
        return this.toFile == null;
    }

    public Writer getToFileWriter(String baseDir) throws IOException {
        if (!this.toFile.isAbsolute()) {
            return new BufferedWriter(new FileWriter(new File(baseDir + System.getProperty("file.separator") + this.toFile.getPath())));
        }
        return new BufferedWriter(new FileWriter(this.toFile));
    }

    public String toString() {
        return "file = " + this.toFile + "; renderer = " + this.renderer.getClass().getName();
    }
}

