/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sourceforge.pmd.ExternalRuleID;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.util.ResourceLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RuleSetFactory {
    public Iterator getRegisteredRuleSets() throws RuleSetNotFoundException {
        try {
            Properties props = new Properties();
            props.load(ResourceLoader.loadResourceAsStream("rulesets/rulesets.properties"));
            String rulesetFilenames = props.getProperty("rulesets.filenames");
            ArrayList<RuleSet> ruleSets = new ArrayList<RuleSet>();
            StringTokenizer st = new StringTokenizer(rulesetFilenames, ",");
            while (st.hasMoreTokens()) {
                ruleSets.add(this.createRuleSet(st.nextToken()));
            }
            return ruleSets.iterator();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Couldn't find rulesets.properties; please ensure that the rulesets directory is on the classpath.  Here's the current classpath: " + System.getProperty("java.class.path"));
        }
    }

    public RuleSet createRuleSet(String name, ClassLoader classLoader) throws RuleSetNotFoundException {
        if (name.indexOf(44) == -1) {
            return this.createRuleSet(this.tryToGetStreamTo(name, classLoader));
        }
        RuleSet ruleSet = new RuleSet();
        StringTokenizer st = new StringTokenizer(name, ",");
        while (st.hasMoreTokens()) {
            String ruleSetName = st.nextToken().trim();
            RuleSet tmpRuleSet = this.createRuleSet(ruleSetName, classLoader);
            ruleSet.addRuleSet(tmpRuleSet);
        }
        return ruleSet;
    }

    public RuleSet createRuleSet(String name) throws RuleSetNotFoundException {
        return this.createRuleSet(name, this.getClass().getClassLoader());
    }

    public RuleSet createRuleSet(InputStream inputStream) {
        return this.createRuleSet(inputStream, this.getClass().getClassLoader());
    }

    public RuleSet createRuleSet(InputStream inputStream, ClassLoader classLoader) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(inputStream);
            Element root = doc.getDocumentElement();
            RuleSet ruleSet = new RuleSet();
            ruleSet.setName(root.getAttribute("name"));
            ruleSet.setDescription(root.getChildNodes().item(1).getFirstChild().getNodeValue());
            NodeList rules = root.getElementsByTagName("rule");
            int i = 0;
            while (i < rules.getLength()) {
                Node ruleNode = rules.item(i);
                if (ruleNode.getAttributes().getNamedItem("ref") != null) {
                    this.parseExternallyDefinedRule(ruleSet, ruleNode);
                } else {
                    this.parseInternallyDefinedRule(ruleSet, ruleNode, classLoader);
                }
                ++i;
            }
            return ruleSet;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Couldn't read from that source: " + e.getMessage());
        }
    }

    private void parseInternallyDefinedRule(RuleSet ruleSet, Node ruleNode, ClassLoader classLoader) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Rule rule = (Rule)Class.forName(ruleNode.getAttributes().getNamedItem("class").getNodeValue(), true, classLoader).newInstance();
        rule.setName(ruleNode.getAttributes().getNamedItem("name").getNodeValue());
        rule.setMessage(ruleNode.getAttributes().getNamedItem("message").getNodeValue());
        Node node = ruleNode.getFirstChild();
        while (node != null) {
            if (node.getNodeName() != null && node.getNodeName().equals("description")) {
                rule.setDescription(node.getFirstChild().getNodeValue());
            }
            if (node.getNodeName() != null && node.getNodeName().equals("priority")) {
                rule.setPriority(Integer.parseInt(node.getFirstChild().getNodeValue().trim()));
            }
            if (node.getNodeName() != null && node.getNodeName().equals("example")) {
                rule.setExample(node.getFirstChild().getNextSibling().getNodeValue());
            }
            this.parseProperties(node, rule);
            node = node.getNextSibling();
        }
        ruleSet.addRule(rule);
    }

    private void parseExternallyDefinedRule(RuleSet ruleSet, Node ruleNode) throws RuleSetNotFoundException {
        String referenceValue = ruleNode.getAttributes().getNamedItem("ref").getNodeValue();
        if (referenceValue.endsWith("xml")) {
            this.parseWithExcludes(ruleNode, referenceValue, ruleSet);
        } else {
            this.parseSimpleReference(referenceValue, ruleSet);
        }
    }

    private void parseSimpleReference(String referenceValue, RuleSet ruleSet) throws RuleSetNotFoundException {
        RuleSetFactory rsf = new RuleSetFactory();
        ExternalRuleID externalRuleID = new ExternalRuleID(referenceValue);
        RuleSet externalRuleSet = rsf.createRuleSet(ResourceLoader.loadResourceAsStream(externalRuleID.getFilename()));
        ruleSet.addRule(externalRuleSet.getRuleByName(externalRuleID.getRuleName()));
    }

    private void parseWithExcludes(Node ruleNode, String referenceValue, RuleSet ruleSet) throws RuleSetNotFoundException {
        NodeList excludeNodes = ruleNode.getChildNodes();
        HashSet<String> excludes = new HashSet<String>();
        int i = 0;
        while (i < excludeNodes.getLength()) {
            Node node = excludeNodes.item(i);
            if (node.getAttributes() != null) {
                excludes.add(node.getAttributes().getNamedItem("name").getNodeValue());
            }
            ++i;
        }
        RuleSetFactory rsf = new RuleSetFactory();
        RuleSet externalRuleSet = rsf.createRuleSet(ResourceLoader.loadResourceAsStream(referenceValue));
        Iterator i2 = externalRuleSet.getRules().iterator();
        while (i2.hasNext()) {
            Rule rule = (Rule)i2.next();
            if (excludes.contains(rule.getName())) continue;
            ruleSet.addRule(rule);
        }
    }

    private void parseProperties(Node node, Rule rule) {
        if (node.getNodeName().equals("properties")) {
            Node propNode = node.getFirstChild().getNextSibling();
            while (propNode != null && propNode.getAttributes() != null) {
                propNode = this.parseProperty(propNode, rule);
            }
        }
    }

    private Node parseProperty(Node propNode, Rule rule) {
        String propValue;
        String propName = propNode.getAttributes().getNamedItem("name").getNodeValue();
        if (propName.equals("xpath")) {
            Node xpathExprNode = propNode.getFirstChild().getNextSibling();
            propValue = xpathExprNode.getFirstChild().getNextSibling().getNodeValue();
            if (propNode.getAttributes().getNamedItem("pluginname") != null) {
                rule.addProperty("pluginname", propNode.getAttributes().getNamedItem("pluginname").getNodeValue());
            }
        } else {
            propValue = propNode.getAttributes().getNamedItem("value").getNodeValue();
        }
        rule.addProperty(propName, propValue);
        return propNode.getNextSibling().getNextSibling();
    }

    private InputStream tryToGetStreamTo(String name, ClassLoader loader) throws RuleSetNotFoundException {
        InputStream in = ResourceLoader.loadResourceAsStream(name, loader);
        if (in == null) {
            throw new RuleSetNotFoundException("Can't find resource " + name + ".  Make sure the resource is a valid file or URL or is on the CLASSPATH");
        }
        return in;
    }
}

