/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.pmd.CommandLineOptions;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.TargetJDK1_3;
import net.sourceforge.pmd.TargetJDK1_4;
import net.sourceforge.pmd.TargetJDKVersion;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.JavaParser;
import net.sourceforge.pmd.ast.ParseException;
import net.sourceforge.pmd.cpd.FileFinder;
import net.sourceforge.pmd.cpd.JavaLanguage;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.symboltable.SymbolFacade;

public class PMD {
    public static final String EOL = System.getProperty("line.separator", "\n");
    private TargetJDKVersion targetJDKVersion;

    public PMD() {
        this.targetJDKVersion = new TargetJDK1_4();
    }

    public PMD(TargetJDKVersion targetJDKVersion) {
        this.targetJDKVersion = targetJDKVersion;
    }

    public void processFile(Reader reader, RuleSet ruleSet, RuleContext ctx) throws PMDException {
        try {
            JavaParser parser = this.targetJDKVersion.createParser(reader);
            ASTCompilationUnit c = parser.CompilationUnit();
            Thread.yield();
            SymbolFacade stb = new SymbolFacade();
            stb.initializeWith(c);
            ArrayList<ASTCompilationUnit> acus = new ArrayList<ASTCompilationUnit>();
            acus.add(c);
            ruleSet.apply(acus, ctx);
            reader.close();
        }
        catch (ParseException pe) {
            throw new PMDException("Error while parsing " + ctx.getSourceCodeFilename(), pe);
        }
        catch (Exception e) {
            throw new PMDException("Error while processing " + ctx.getSourceCodeFilename(), e);
        }
    }

    public void processFile(InputStream fileContents, RuleSet ruleSet, RuleContext ctx) throws PMDException {
        this.processFile(new InputStreamReader(fileContents), ruleSet, ctx);
    }

    public static void main(String[] args) {
        block9: {
            CommandLineOptions opts = new CommandLineOptions(args);
            List files = opts.containsCommaSeparatedFileList() ? PMD.collectFromCommaDelimitedString(opts.getInputFileName()) : PMD.collectFilesFromOneName(opts.getInputFileName());
            PMD pmd = opts.jdk13() ? new PMD(new TargetJDK1_3()) : new PMD();
            RuleContext ctx = new RuleContext();
            ctx.setReport(new Report());
            try {
                RuleSetFactory ruleSetFactory = new RuleSetFactory();
                RuleSet rules = ruleSetFactory.createRuleSet(opts.getRulesets());
                Iterator i = files.iterator();
                while (i.hasNext()) {
                    File file = (File)i.next();
                    ctx.setSourceCodeFilename(PMD.glomName(opts.shortNamesEnabled(), opts.getInputFileName(), file));
                    try {
                        pmd.processFile(new FileInputStream(file), rules, ctx);
                    }
                    catch (PMDException pmde) {
                        if (opts.debugEnabled()) {
                            pmde.getReason().printStackTrace();
                        }
                        ctx.getReport().addError(new Report.ProcessingError(pmde.getMessage(), PMD.glomName(opts.shortNamesEnabled(), opts.getInputFileName(), file)));
                    }
                }
            }
            catch (FileNotFoundException fnfe) {
                System.out.println(opts.usage());
                fnfe.printStackTrace();
            }
            catch (RuleSetNotFoundException rsnfe) {
                System.out.println(opts.usage());
                rsnfe.printStackTrace();
            }
            try {
                Renderer r = opts.createRenderer();
                System.out.println(r.render(ctx.getReport()));
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                System.out.println(opts.usage());
                if (!opts.debugEnabled()) break block9;
                e.printStackTrace();
            }
        }
    }

    private static String glomName(boolean shortNames, String inputFileName, File file) {
        if (shortNames && inputFileName.indexOf(44) == -1) {
            if (new File(inputFileName).isDirectory()) {
                return PMD.trimAnyPathSep(file.getAbsolutePath().substring(inputFileName.length()));
            }
            if (inputFileName.indexOf(System.getProperty("file.separator").charAt(0)) == -1) {
                return inputFileName;
            }
            return PMD.trimAnyPathSep(inputFileName.substring(inputFileName.lastIndexOf(System.getProperty("file.separator"))));
        }
        return file.getAbsolutePath();
    }

    private static String trimAnyPathSep(String name) {
        if (name.startsWith(System.getProperty("file.separator"))) {
            name = name.substring(1);
        }
        return name;
    }

    private static List collectFilesFromOneName(String inputFileName) {
        return PMD.collect(inputFileName);
    }

    private static List collectFromCommaDelimitedString(String fileList) {
        ArrayList files = new ArrayList();
        StringTokenizer st = new StringTokenizer(fileList, ",");
        while (st.hasMoreTokens()) {
            files.addAll(PMD.collect(st.nextToken()));
        }
        return files;
    }

    private static List collect(String filename) {
        List<File> files;
        File inputFile = new File(filename);
        if (!inputFile.exists()) {
            throw new RuntimeException("File " + inputFile.getName() + " doesn't exist");
        }
        if (!inputFile.isDirectory()) {
            files = new ArrayList<File>();
            files.add(inputFile);
        } else {
            FileFinder finder = new FileFinder();
            files = finder.findFilesFrom(inputFile.getAbsolutePath(), new JavaLanguage.JavaFileOrDirectoryFilter(), true);
        }
        return files;
    }
}

