/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.JavaParserVisitorAdapter;

public abstract class AbstractRule
extends JavaParserVisitorAdapter
implements Rule {
    private String name = this.getClass().getName();
    private Properties properties = new Properties();
    private String message;
    private String description;
    private String example;
    private boolean m_include;
    private int m_priority = 5;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getExample() {
        return this.example;
    }

    public void setExample(String example) {
        this.example = example;
    }

    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    public void addProperty(String name, String value) {
        this.properties.setProperty(name, value);
    }

    public double getDoubleProperty(String name) {
        return Double.parseDouble(this.properties.getProperty(name));
    }

    public int getIntProperty(String name) {
        return Integer.parseInt(this.properties.getProperty(name));
    }

    public boolean getBooleanProperty(String name) {
        return Boolean.valueOf(this.properties.getProperty(name));
    }

    public String getStringProperty(String name) {
        return this.properties.getProperty(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Rule)) {
            return false;
        }
        return ((Rule)o).getName().equals(this.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    protected void visitAll(List acus, RuleContext ctx) {
        Iterator i = acus.iterator();
        while (i.hasNext()) {
            ASTCompilationUnit node = (ASTCompilationUnit)i.next();
            this.visit(node, (Object)ctx);
        }
    }

    public void apply(List acus, RuleContext ctx) {
        this.visitAll(acus, ctx);
    }

    public RuleViolation createRuleViolation(RuleContext ctx, int lineNumber) {
        return new RuleViolation(this, lineNumber, ctx);
    }

    public RuleViolation createRuleViolation(RuleContext ctx, int lineNumber, String specificDescription) {
        return new RuleViolation(this, lineNumber, specificDescription, ctx);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public boolean include() {
        return this.m_include;
    }

    public void setInclude(boolean include) {
        this.m_include = include;
    }

    public int getPriority() {
        if (this.m_priority < 0 || this.m_priority > 5) {
            this.m_priority = 5;
        }
        return this.m_priority;
    }

    public String getPriorityName() {
        return Rule.PRIORITIES[this.getPriority() - 1];
    }

    public void setPriority(int priority) {
        this.m_priority = priority < 1 || priority > 5 ? 5 : priority;
    }
}

