/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jxpath.JXPathBeanInfo;

public class JXPathBasicBeanInfo
implements JXPathBeanInfo {
    private static final PropertyDescriptor[] staticPDSArray = new PropertyDescriptor[0];
    private static final HashMap staticFinalHashMap = new HashMap();
    private boolean atomic = false;
    private Class clazz;
    private PropertyDescriptor[] propertyDescriptors;
    private Map propertyIndex;
    private Class dynamicPropertyHandlerClass;

    public JXPathBasicBeanInfo(Class clazz) {
        this.clazz = clazz;
        try {
            BeanInfo bi = null;
            bi = clazz.isInterface() ? Introspector.getBeanInfo(clazz) : Introspector.getBeanInfo(clazz, Object.class);
            PropertyDescriptor[] pds = bi.getPropertyDescriptors();
            this.propertyDescriptors = new PropertyDescriptor[pds.length];
            System.arraycopy(pds, 0, this.propertyDescriptors, 0, pds.length);
            Arrays.sort(this.propertyDescriptors, new Comparator(){

                public int compare(Object left, Object right) {
                    return ((PropertyDescriptor)left).getName().compareTo(((PropertyDescriptor)right).getName());
                }
            });
            pds = this.propertyDescriptors;
            this.propertyIndex = new HashMap();
            for (int i = 0; i < pds.length; ++i) {
                String propertyName = pds[i].getName();
                char c = propertyName.charAt(0);
                c = Character.isLowerCase(c) ? Character.toUpperCase(c) : Character.toLowerCase(c);
                StringBuffer buf = new StringBuffer();
                char[] ch = propertyName.toCharArray();
                ch[0] = c;
                buf.append(ch, 0, ch.length);
                String alternatePropertyName = buf.toString();
                this.propertyIndex.put(propertyName, pds[i]);
                this.propertyIndex.put(alternatePropertyName, pds[i]);
            }
        }
        catch (IntrospectionException ex) {
            ex.printStackTrace();
        }
    }

    public JXPathBasicBeanInfo(Class clazz, boolean atomic) {
        this.clazz = clazz;
        this.atomic = atomic;
        this.propertyDescriptors = staticPDSArray;
        this.propertyIndex = staticFinalHashMap;
    }

    public JXPathBasicBeanInfo(Class clazz, Class dynamicPropertyHandlerClass) {
        this.atomic = false;
        this.dynamicPropertyHandlerClass = dynamicPropertyHandlerClass;
        this.clazz = clazz;
        this.propertyDescriptors = staticPDSArray;
        this.propertyIndex = staticFinalHashMap;
    }

    public boolean isAtomic() {
        return this.atomic;
    }

    public boolean isDynamic() {
        return this.dynamicPropertyHandlerClass != null;
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    public PropertyDescriptor getPropertyDescriptor(String propertyName) {
        return (PropertyDescriptor)this.propertyIndex.get(propertyName);
    }

    public Class getDynamicPropertyHandlerClass() {
        return this.dynamicPropertyHandlerClass;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("BeanInfo [class = ");
        buffer.append(this.clazz.getName());
        buffer.append(", properties = ");
        PropertyDescriptor[] jpds = this.getPropertyDescriptors();
        for (int i = 0; i < jpds.length; ++i) {
            buffer.append("\n    ");
            buffer.append(jpds[i].getPropertyType());
            buffer.append(": ");
            buffer.append(jpds[i].getName());
        }
        buffer.append("]");
        return buffer.toString();
    }
}

