/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.fetcher.impl;

import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.fetcher.FetcherException;
import com.sun.syndication.fetcher.impl.AbstractFeedFetcher;
import com.sun.syndication.fetcher.impl.FeedFetcherCache;
import com.sun.syndication.fetcher.impl.SyndFeedInfo;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;

public class HttpClientFeedFetcher
extends AbstractFeedFetcher {
    private FeedFetcherCache feedInfoCache;
    private CredentialSupplier credentialSupplier;

    public HttpClientFeedFetcher() {
    }

    public HttpClientFeedFetcher(FeedFetcherCache cache) {
        this();
        this.feedInfoCache = cache;
    }

    public HttpClientFeedFetcher(FeedFetcherCache cache, CredentialSupplier credentialSupplier) {
        this(cache);
        this.credentialSupplier = credentialSupplier;
    }

    public CredentialSupplier getCredentialSupplier() {
        return this.credentialSupplier;
    }

    public void setCredentialSupplier(CredentialSupplier credentialSupplier) {
        this.credentialSupplier = credentialSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyndFeed retrieveFeed(URL feedUrl) throws IllegalArgumentException, IOException, FeedException, FetcherException {
        if (feedUrl == null) {
            throw new IllegalArgumentException("null is not a valid URL");
        }
        HttpClient client = new HttpClient();
        if (this.getCredentialSupplier() != null) {
            client.getState().setAuthenticationPreemptive(true);
            Credentials credentials = this.getCredentialSupplier().getCredentials(null, feedUrl.getHost());
            if (credentials != null) {
                client.getState().setCredentials(null, feedUrl.getHost(), credentials);
            }
        }
        System.setProperty("httpclient.useragent", this.getUserAgent());
        String urlStr = feedUrl.toString();
        if (this.feedInfoCache != null) {
            SyndFeedInfo syndFeedInfo = this.feedInfoCache.getFeedInfo(feedUrl);
            GetMethod method = new GetMethod(urlStr);
            method.addRequestHeader("Accept-Encoding", "gzip");
            try {
                if (this.isUsingDeltaEncoding()) {
                    method.setRequestHeader("A-IM", "feed");
                }
                if (syndFeedInfo != null) {
                    method.setRequestHeader("If-None-Match", syndFeedInfo.getETag());
                    if (syndFeedInfo.getLastModified() instanceof String) {
                        method.setRequestHeader("If-Modified-Since", (String)syndFeedInfo.getLastModified());
                    }
                }
                method.setFollowRedirects(true);
                int statusCode = client.executeMethod((HttpMethod)method);
                this.fireEvent("FEED_POLLED", urlStr);
                this.handleErrorCodes(statusCode);
                SyndFeed feed = this.retrieveFeed(syndFeedInfo, urlStr, (HttpMethod)method, statusCode);
                syndFeedInfo = this.buildSyndFeedInfo(feedUrl, urlStr, (HttpMethod)method, feed, statusCode);
                this.feedInfoCache.setFeedInfo(new URL(urlStr), syndFeedInfo);
                SyndFeed syndFeed = feed = syndFeedInfo.getSyndFeed();
                return syndFeed;
            }
            finally {
                method.releaseConnection();
            }
        }
        GetMethod method = new GetMethod(urlStr);
        try {
            method.setFollowRedirects(true);
            int statusCode = client.executeMethod((HttpMethod)method);
            this.fireEvent("FEED_POLLED", urlStr);
            this.handleErrorCodes(statusCode);
            SyndFeed syndFeed = this.retrieveFeed(null, urlStr, (HttpMethod)method, statusCode);
            return syndFeed;
        }
        finally {
            method.releaseConnection();
        }
    }

    private SyndFeedInfo buildSyndFeedInfo(URL feedUrl, String urlStr, HttpMethod method, SyndFeed feed, int statusCode) throws MalformedURLException {
        Header eTagHeader;
        Header lastModifiedHeader;
        SyndFeedInfo cachedInfo;
        SyndFeedInfo syndFeedInfo = new SyndFeedInfo();
        syndFeedInfo.setUrl(new URL(urlStr));
        syndFeedInfo.setId(feedUrl.toString());
        Header imHeader = method.getResponseHeader("IM");
        if (imHeader != null && imHeader.getValue().indexOf("feed") >= 0 && this.isUsingDeltaEncoding() && this.feedInfoCache != null && statusCode == 226 && (cachedInfo = this.feedInfoCache.getFeedInfo(feedUrl)) != null) {
            SyndFeed cachedFeed = cachedInfo.getSyndFeed();
            feed = HttpClientFeedFetcher.combineFeeds(cachedFeed, feed);
        }
        if ((lastModifiedHeader = method.getResponseHeader("Last-Modified")) != null) {
            syndFeedInfo.setLastModified(lastModifiedHeader.getValue());
        }
        if ((eTagHeader = method.getResponseHeader("ETag")) != null) {
            syndFeedInfo.setETag(eTagHeader.getValue());
        }
        syndFeedInfo.setSyndFeed(feed);
        return syndFeedInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SyndFeed retrieveFeed(SyndFeedInfo syndFeedInfo, String urlStr, HttpMethod method, int statusCode) throws IOException, HttpException, FetcherException, FeedException {
        if (statusCode == 304 && syndFeedInfo != null) {
            this.fireEvent("FEED_UNCHANGED", urlStr);
            return syndFeedInfo.getSyndFeed();
        }
        InputStream stream = null;
        stream = method.getResponseHeader("Content-Encoding") != null && "gzip".equalsIgnoreCase(method.getResponseHeader("Content-Encoding").getValue()) ? new GZIPInputStream(method.getResponseBodyAsStream()) : method.getResponseBodyAsStream();
        try {
            XmlReader reader = null;
            reader = method.getResponseHeader("Content-Type") != null ? new XmlReader(stream, method.getResponseHeader("Content-Type").getValue(), true) : new XmlReader(stream, true);
            SyndFeed feed = new SyndFeedInput().build((Reader)reader);
            this.fireEvent("FEED_RETRIEVED", urlStr, feed);
            SyndFeed syndFeed = feed;
            return syndFeed;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public static interface CredentialSupplier {
        public Credentials getCredentials(String var1, String var2);
    }
}

