/*
 * Copyright (c) 1996,1997 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

#include <sys/param.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <syslog.h>

#include <atalk/adouble.h>

#include "directory.h"
#include "fork.h"

static struct ofork	**oforks;
static int		nforks;
static u_short		lastrefnum = 0;

pforkdesc( f )
    FILE	*f;
{
    u_short	ofrefnum;

    for ( ofrefnum = 0; ofrefnum < nforks; ofrefnum++ ) {
	if ( oforks[ ofrefnum ] != NULL ) {
	    fprintf( f, "%hu <%s>\n", ofrefnum, oforks[ ofrefnum ]->of_name );
	}
    }
}

of_init()
{
    struct rlimit	rl;

    if ( getrlimit( RLIMIT_NOFILE, &rl ) < 0 ) {
	syslog( LOG_ERR, "of_init: getrlimit: %m" );
	exit( 1 );
    }
    if ( rl.rlim_cur < rl.rlim_max ) {
	rl.rlim_cur = rl.rlim_max;
	if ( setrlimit( RLIMIT_NOFILE, &rl ) < 0 ) {
	    syslog( LOG_ERR, "of_init: setrlimit: %m" );
	    exit( 1 );
	}
    }

    nforks = ( rl.rlim_cur - 10 ) / 2;
    if (( oforks = (struct ofork **)calloc( nforks, sizeof( struct ofork ))) ==
	    NULL ) {
	syslog( LOG_ERR, "of_init: malloc: %m" );
	exit( 1 );
    }

    return;
}

of_flush()
{
    u_short	refnum;

    for ( refnum = 0; refnum < nforks; refnum++ ) {
	if ( oforks[ refnum ] != NULL &&
		flushfork( oforks[ refnum ] ) < 0 ) {
	    syslog( LOG_ERR, "of_flush: %m" );
	}
    }
    return( 0 );
}

    struct ofork *
of_alloc( dir, path, ofrefnum )
    struct dir		*dir;
    char		*path;
    u_short		*ofrefnum;
{
    u_short		refnum;
    int			i;

    for ( refnum = lastrefnum++, i = 0; i < nforks; i++, refnum++ ) {
	if ( oforks[ refnum % nforks ] == NULL ) {
	    break;
	}
    }
    if ( i == nforks ) {
	return( NULL );
    }

    if (( oforks[ refnum % nforks ] =
	    (struct ofork *)malloc( sizeof( struct ofork ))) == NULL ) {
	syslog( LOG_ERR, "of_alloc: malloc: %m" );
	exit( 1 );
    }
    oforks[ refnum % nforks ]->of_dir = dir;
    if (( oforks[ refnum % nforks ]->of_name =
	    (char *)malloc( strlen( path ) + 1 )) == NULL ) {
	syslog( LOG_ERR, "of_alloc: malloc: %m" );
	exit( 1 );
    }
    strcpy( oforks[ refnum % nforks ]->of_name, path );
    *ofrefnum = refnum;
    return( oforks[ refnum % nforks ] );
}

    struct ofork *
of_find( ofrefnum )
    u_short	ofrefnum;
{
    return( oforks[ ofrefnum % nforks ] );
}

of_dealloc( of )
    struct ofork	*of;
{
    u_short		refnum;

    for ( refnum = 0; refnum < nforks; refnum++ ) {
	if ( oforks[ refnum ] == of ) {
	    break;
	}
    }
    if ( refnum == nforks ) {
	syslog( LOG_ERR, "of_dealloc: OOPS!" );
	return;
    }

    free( of );
    free( of->of_name );
    oforks[ refnum ] = NULL;
    return;
}

    struct ofork *
of_findfile( dir, path )
    struct dir	*dir;
    char	*path;
{
    u_short		refnum;
    int			i;

    for ( i = 0; i < nforks; i++ ) {
	if ( oforks[ i ] != NULL && oforks[ i ]->of_dir == dir &&
		strcmp( oforks[ i ]->of_name, path ) == 0 )  {
	    break;
	}
    }
    if ( i == nforks ) {
	return( NULL );
    }
    return( oforks[ i ] );
}
