#TRUSTED 3d88c99234c831cffffbe90fe82333da1adee5788365514690ca8107646283098997dc182f9c35977e95de5a5441080b6b951133d44e8cf55eea5e01067a50c55f25dd08bc15816f7abfb898f85fb5bbd2d0998a6d8969d7205c752ea8906e6535885b1581ca62e0a1d2b51486940bb082e8f974e76474fbaea549eef5d49e4de5a5912bc4b58624c0d77201f2f10b86123e972155c8f54187300407ebfd3284d751c46a3259e1b3661188b4d7af0d8c8e0d5dd0c7bc5f1d7056c273a5c020807469ea49ab25018b8e0054a913c398529dba449a6bb8badf421c6143b60e44f31c043b7581c401a70705282aabb865c617aa6fe2a35cb843fc95420aec1eec781bb3f607e4f9520e4d85b1991ca97471524199ed7b073fe196e23e0033b8fd379e24c7b4e7c61183a5aee3673d969d0e2b57f2ca0d703bbd83c383a3efcf11fcc19c4cf90ea98242e515d8d119ab5e3d9711d59994048185c10177ea934d2b927e0ea0f2b52414c5dacc27cab3371284d1d701e535bf6f8f161248d7a7181b17056ea2eba9719fb498e8999bc4f85e2d8555365e13e00da0b95b4dbb7a0f465dd403a9638af9aafcec4fd0bfe69d012be72286aec092f3ca1060930ca4ecf8fd770af2273c91a94f18321f1eed56d1f582c38e2e9a63c3a9bfba3ad092d7439a82be13b44af5f3560556108b993af1a7f402a25f56f42b978702a1e916764f74
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15889);
 script_version ("1.1");
 name["english"] = "Hydra: telnet";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find telnet passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force telnet authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/telnet", 23);
 script_dependencies("hydra_options.nasl", "find_service.nes", "doublecheck_std_services.nasl");
 exit(0);
}

#
thorough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< thorough) exit(0);
logins = get_kb_item("Secret/hydra/logins_file");
passwd = get_kb_item("Secret/hydra/passwords_file");
if (logins == NULL || passwd == NULL) exit(0);

port = get_kb_item("Services/telnet");
if (! port) port = 23;
if (! get_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
argv[i++] = "-P"; argv[i++] = passwd;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "telnet";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'username: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/telnet/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following Telnet accounts:\n' + report);
