#TRUSTED 80e18b4f859e86b8d08f31bac205efef169ce4d0bfade6ca9aecd2d439f2892809ef53213fd6e726a561deff832ac7f721b089166b9bfb8c458b9425c5fdeacc92de7dcd9c52a6f49efc6d633218d51e6f07aed5ecb9d39da937e65af7326217c672e09e95493a896342b89c14cd755a10114d17f93df8326ea673ce081a61e1339224e75ff34f2b4d1d4478dcd4b00629b3f54e1963e4b7142d95324e0bcfaf828b7d8e9ab937547dd9635a330c564f21dd8c16b484ace953bd3b090a887f4461c522f5d638369a05a91396e947903ec3eec33c941ae0211dcd6dd6f139288c1944556b6fced7c59fc1a8523e4abfb1e2b7663f63d0448b83d9e2c5d98afcd4261bcae0b58d6491af51e037852e7b6add5389be6ed17abad885169689f80e8eb0e7076d99c4140f0b882f61ff39a56c18b4a39bb3ac1c03467afcd44697c1ad18575bc211e0ed1b132a1ffbde260ed9ea121f10470726333724cbc363afe978d2c395dc124364b5ad1d22a57088bfc68361d2633512b1e144ed2cbdb1b165941cef32153ddd95e6d89d99690832e912a9b44ef85f235128c185d77e04946a04861b9ad27936e4d08d8ea756a6b1080d3d04b9094fe0623874f8d0c00f81cac26926c69d79eba62569bd22aad28f3161d4a2d804ecf041788bd34d08c19f5705d9a878aff0deafb24be67ca5100e49c3e40def0efaa432bb89f098a0085bb49f
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15888);
 script_version ("1.1");
 name["english"] = "Hydra: SSH2";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find SSH2 accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force SSH2 authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/ssh", 22);
 script_dependencies("hydra_options.nasl", "find_service.nes", "doublecheck_std_services.nasl");
 exit(0);
}

#
thorough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< thorough) exit(0);
logins = get_kb_item("Secret/hydra/logins_file");
passwd = get_kb_item("Secret/hydra/passwords_file");
if (logins == NULL || passwd == NULL) exit(0);

port = get_kb_item("Services/ssh");
if (! port) port = 22;
if (! get_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
argv[i++] = "-P"; argv[i++] = passwd;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "ssh2";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'username: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/ssh2/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following SSH accounts:\n' + report);
